output "consul_elb_arn" {
  description = "The ARN of the ELB created to front the consul cluster in this region, env."
  value       = aws_lb.consul_alb.arn
}

output "consul_lb_tg_arn" {
  description = "The ARN of the target group of the ELB created to front the consul cluster in this region, env."
  value       = aws_lb_target_group.consul_server_tg.arn
}

output "consul_vpce_name" {
  description = "The name for the consul VPC endpoint service. Used by consumers to discover service endpoints when they create interface endpoints in their account(s)."
  value       = module.consul_vpc_endpoint_service.vpce_service_name
}

output "consul_vpce_service_dns_name" {
  description = "The base DNS name of the VPC endpoint service created. Will not be directly used in production."
  value       = module.consul_vpc_endpoint_service.vpce_service_dns_name
}

output "consul_vpce_service_private_dns_name" {
  description = "The private DNS name of the VPC endpoint service created. Will be empty on initial creation. Once created, will output the private DNS name."
  value       = module.consul_vpc_endpoint_service.vpce_service_private_dns_name
}
