# Optional inputs
variable "backend_bucket" {
  description = "The S3 bucket to store terraform remote state"
}

variable "env" {
  description = "Service environment - (prod|staging)"
  default     = "staging"
}

variable "role" {
  description = "Service role (now known as machine class)"
}

variable "aws_region" {
  description = "The AWS region this service will be deployed"
  default     = "us-west-2"
}

variable "instance_type" {
  description = "EC2 instance type this service will be running on"
  default     = "c5.4xlarge"
}

variable "asg_size" {
  description = "Static size of the ASG"
  default     = 5
}

variable "vpce_allowed_principals" {
  description = "The list of trusted accounts for the VPCe."
  default     = []
}

locals {
  environment_map = {
    prod    = "production"
    stage   = "staging"
    staging = "staging"
    dev     = "development"
  }

  environment = local.environment_map[var.env]

  common_tags = {
    Owner       = "video-coreservices@twitch.tv"
    Service     = "consul"
    Environment = var.env
    Source      = "video-coreservices/tf-io-consul-master-asg"
  }

  # The VPC ID's of consul clusters
  vpc_map = {
    us-west-2 = "vpc-23fa3f44"
    us-east-1 = "vpc-38ab5f41"
    eu-west-2 = "vpc-06218027b22527cc3"
    us-east-2 = "vpc-00b410e83884d58b9"
  }
  consul_vpc = local.vpc_map[var.aws_region]

  # IVS dataplane security groups for the vpcs above
  sg_map = {
    us-west-2 = "sg-c60157bf"
    us-east-1 = "sg-992ebae7"
    eu-west-2 = "sg-07ab05d221c539bc5"
    us-east-2 = "sg-04f8cefd35cd10e42"
  }
  consul_ec2_sg = local.sg_map[var.aws_region]

  # <region>.<env> zone IDs
  r53_zone_id_map = {
    us-west-2 = "Z3NO8D5Q1PTMYS"
    us-east-1 = "Z115506K1BRVW1"
    eu-west-2 = "Z0727490341AQ9LLVLALW"
    us-east-2 = "Z0025747FDG0I6K0OEKW"
  }
  consul_r53_zone_id = local.r53_zone_id_map[var.aws_region]

}
