# DNS Validator

This code setups and manages the infrastructure to validate DDNS updates from machines, and forwards it to a SNS topic where other clients can consume.

Refer [wiki](https://wiki.xarth.tv/display/VID/DNS+Validator+and+DDNS+Updates) for overview.

<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->


- [Components](#components)
  - [dns_resolver](#dns_resolver)
  - [dns_validator_lambda](#dns_validator_lambda)
- [Accounts](#accounts)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->

# Components

This module is split out to multiple submodules:

## [dns_resolver](./src/dns_resolver)

This module sets up Route53 resolvers required in the respective account to be able to resolve `justin.tv` DNS.

## [dns_validator_lambda](./src/dns_validator_lambda)

__This is the most likely where most if not all changes are to be made__.

This module manages the SNS topics and lambda which validates DDNS updates from machines, validates that this is an expected payload from machine, and forwards to a SNS topic where other clients can consume.

# Accounts

The following accounts are utilized to manage this infrastructure.

| Environment | Region     | Account  |
|-------------|------------|----------|
| prod        | us-east-2  | 625436545767 |
| prod        | us-west-2  | 190359952526 |
| staging     | us-west-2  | 152548578290 |
