# Route53 Resolvers to resolve justin.tv

This module sets up Route53 resolvers required in the respective account to be able to resolve `justin.tv` DNS. This requires DX connectivity to Twitch network, to be able to query Twitch's internal DNS resolvers.

Note that this module is **only setup for prod accounts**, as staging accounts are setup in the VidOps staging party account, which has Route53 resolvers setup before.

# Usage

<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->


- [Requirements](#requirements)
- [Deployment](#deployment)
  - [Example run](#example-run)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->

# Requirements

* [tfenv](https://github.com/tfutils/tfenv#automatic)
* AWS credentials to assume `Admin` roles of the respective accounts.
  | Environment | Region     | Account  | isengardcli  |
  |-------------|------------|----------|--------------|
  | prod        | us-east-2  | 625436545767 | `isengardcli creds twitch-vidcs+ddns-validator-prod-us-east-2 --role Admin`  |
  | prod        | us-west-2  | 190359952526 | `isengardcli creds twitch-vidcs+ddns-validator-prod-us-west-2 --role Admin` |

# Deployment

To apply changes, use `./deploy.sh` to run commands.

```bash
./deploy.sh -e <env> -r <region> <terraform-action>
```

## Example run

```terraform
> ./deploy.sh -e prod -r us-west-2 plan
Initializing modules...

Initializing the backend...

Successfully configured the backend "s3"! Terraform will automatically
use this backend unless the backend configuration changes.

Initializing provider plugins...

Terraform has been successfully initialized!

You may now begin working with Terraform. Try running "terraform plan" to see
any changes that are required for your infrastructure. All Terraform commands
should now work.

If you ever set or change modules or backend configuration for Terraform,
rerun this command to reinitialize your working directory. If you forget, other
commands will detect it and remind you to do so if necessary.
Refreshing Terraform state in-memory prior to plan...
The refreshed state will be used to calculate this plan, but will not be
persisted to local or remote state storage.

aws_security_group.dns_to_justin_tv_resolver: Refreshing state... [id=sg-09cc48d550e8fb228]
aws_route53_resolver_endpoint.vpc_outbound_dns: Refreshing state... [id=rslvr-out-be31ffb229d747bda]
aws_route53_resolver_rule.fwd_justin_tv: Refreshing state... [id=rslvr-rr-51ea1c37062a45999]
aws_route53_resolver_rule_association.fwd_justin_tv: Refreshing state... [id=rslvr-rrassoc-c62c9f8d0e6a4875a]

------------------------------------------------------------------------

No changes. Infrastructure is up-to-date.

This means that Terraform did not detect any differences between your
configuration and real physical resources that exist. As a result, no
actions need to be performed.

```
