# DNS Validator

This module manages the SNS topics and lambda which validates DDNS updates from machines, validates that this is an expected payload from machine, and forwards to a SNS topic where other clients can consume.

# Usage

<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->


- [Requirements](#requirements)
- [Deployment](#deployment)
  - [Example run](#example-run)
- [Development](#development)
  - [Testing](#testing)
    - [Example test](#example-test)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->

# Requirements

* [tfenv](https://github.com/tfutils/tfenv#automatic)
* AWS credentials to assume `Admin` roles of the respective accounts.
  | Environment | Region     | Account  | isengardcli  |
  |-------------|------------|----------|--------------|
  | prod        | us-east-2  | 625436545767 | `isengardcli creds twitch-vidcs+ddns-validator-prod-us-east-2 --role Admin`  |
  | prod        | us-west-2  | 190359952526 | `isengardcli creds twitch-vidcs+ddns-validator-prod-us-west-2 --role Admin` |
  | staging     | us-west-2  | 152548578290 | `isengardcli creds twitch-bs-video-ops-stg --role Admin`  |

# Deployment

Both infrastructure (AWS components) and lambda code (artifact) is managed by a terraform run.

1. For infrastructure changes, the expected terraform changes are applied immediately when run.
1. For lambda (code changes) deployments, a local S3 artifact is generated during the terraform run, uploads to S3, which triggers a codedeploy pipeline to build the lambda artifact and deploy the changes to lambda.

To apply changes, use `./deploy.sh` to run commands.

```bash
./deploy.sh -e <env> -r <region> <terraform-action>
```

## Example run

```terraform
> ./deploy.sh -e staging -r us-west-2 plan
Initializing modules...

Initializing the backend...

Successfully configured the backend "s3"! Terraform will automatically
use this backend unless the backend configuration changes.

Initializing provider plugins...

The following providers do not have any version constraints in configuration,
so the latest version was installed.

To prevent automatic upgrades to new major versions that may contain breaking
changes, it is recommended to add version = "..." constraints to the
corresponding provider blocks in configuration, with the constraint strings
suggested below.

* provider.local: version = "~> 2.1"

Terraform has been successfully initialized!

You may now begin working with Terraform. Try running "terraform plan" to see
any changes that are required for your infrastructure. All Terraform commands
should now work.

If you ever set or change modules or backend configuration for Terraform,
rerun this command to reinitialize your working directory. If you forget, other
commands will detect it and remind you to do so if necessary.
Refreshing Terraform state in-memory prior to plan...
The refreshed state will be used to calculate this plan, but will not be
persisted to local or remote state storage.

random_uuid.lambda_src_hash: Refreshing state... [id=bd2f38df-09df-7dd8-0393-bd1d170e6e04]
module.slack_chatbot.data.local_file.cloudformation_template: Refreshing state...
module.cloudwatch_wiki.data.local_file.cloudformation_template_xa: Refreshing state...
module.cloudwatch_wiki.data.local_file.cloudformation_template: Refreshing state...
data.archive_file.lambda_code: Refreshing state...
module.slack_sns.data.aws_caller_identity.current: Refreshing state...
module.cloudwatch_wiki.aws_cloudformation_stack.cross_account_cloudwatch_configuration: Refreshing state... [id=arn:aws:cloudformation:us-east-2:625436545767:stack/CloudWatch-CrossAccountSharingRole/43c786e0-0b58-11ec-ade6-066c0a3b9600]
module.dns_validate_lambda_deploy_stack.aws_iam_role.service_codedeploy_role: Refreshing state... [id=dns-validator-codedeploy-service-role]
data.aws_caller_identity.caller: Refreshing state...
aws_sqs_queue.dns_validate_deadletter: Refreshing state... [id=https://sqs.us-east-2.amazonaws.com/625436545767/dns-validate-deadletter]
module.dns_validate_lambda_deploy_stack.aws_iam_role.service_codebuild_role: Refreshing state... [id=dns-validator-codebuild-service-role]
module.vidcs_pagerduty.aws_sns_topic.business_hours_alarm: Refreshing state... [id=arn:aws:sns:us-east-2:625436545767:dns-validator-all-hours-alarm20210811003820403100000001]
module.dns_validate_lambda_deploy_stack.aws_s3_bucket.service_codepipeline_bucket: Refreshing state... [id=dns-validator-codepipeline-bucket-prod-us-east-2]
module.dns_validate_lambda_deploy_stack.data.aws_caller_identity.caller: Refreshing state...
module.video_org_principal_destination.data.aws_iam_policy_document.organization_principal_policy_statement: Refreshing state...
module.dns_validate_lambda_deploy_stack.aws_iam_policy.service_codepipeline_allow: Refreshing state... [id=arn:aws:iam::625436545767:policy/codepipeline-dns-validator-allow]
module.slack_chatbot.data.aws_caller_identity.current: Refreshing state...
module.dns_validate_lambda_deploy_stack.aws_s3_bucket.service_release_bucket: Refreshing state... [id=dns-validator-release-bucket-prod-us-east-2]
module.dns_validate_lambda_deploy_stack.aws_codedeploy_app.service_codedeploy_app: Refreshing state... [id=13848c16-c3e0-4367-bae2-63d93859cb78:dns-validator-deploy]
module.vidcs_pagerduty.aws_sns_topic.all_hours_alarm: Refreshing state... [id=arn:aws:sns:us-east-2:625436545767:dns-validator-business-hours-alarm20210811003820403100000002]
aws_s3_bucket.service_codesource_bucket: Refreshing state... [id=dns-validator-codesource-bucket-prod-us-east-2]
aws_sns_topic.crud_sanitized_topic: Refreshing state... [id=arn:aws:sns:us-east-2:625436545767:ddns-verified-machines]
aws_sns_topic.crud_updater_topic: Refreshing state... [id=arn:aws:sns:us-east-2:625436545767:hls-dns-crud-updater]
aws_sqs_queue.dns_validate_delay_deadletter: Refreshing state... [id=https://sqs.us-east-2.amazonaws.com/625436545767/dns-validate-delay-deadletter]
module.slack_chatbot.data.aws_iam_policy_document.chatbot_policy: Refreshing state...
module.dns_validate_lambda_deploy_stack.aws_iam_role.service_codepipeline_role: Refreshing state... [id=dns-validator-codepipeline-service-role]
aws_iam_role.dns_validate_lambda_role: Refreshing state... [id=dns-validate-lambda-role]
module.cloudwatch_wiki.aws_cloudformation_stack.cloudwatchdashboard_wiki_configuration: Refreshing state... [id=arn:aws:cloudformation:us-east-2:625436545767:stack/cloudwatch-dashboard-wiki/43c75fd0-0b58-11ec-ade6-066c0a3b9600]
module.dns_validate_lambda_deploy_stack.aws_iam_role_policy_attachment.service_codedeploy_role_policy_attach: Refreshing state... [id=dns-validator-codedeploy-service-role-20210810230926238400000003]
module.vidcs_pagerduty.aws_sns_topic_subscription.business_hours_pd_subscription: Refreshing state... [id=arn:aws:sns:us-east-2:625436545767:dns-validator-all-hours-alarm20210811003820403100000001:872c0366-fc3e-4a5a-9735-e5a4d40356d5]
module.dns_validate_lambda_deploy_stack.aws_codedeploy_deployment_group.service_codedeploy_group: Refreshing state... [id=6da85a70-0472-4ff1-91ad-1e95a1f87d4b]
module.slack_chatbot.aws_iam_role.chatbot_role: Refreshing state... [id=codepipeline-chatbot-role]
aws_sqs_queue.dns_validate_queue: Refreshing state... [id=https://sqs.us-east-2.amazonaws.com/625436545767/dns-validate-queue]
aws_iam_role_policy_attachment.dns_validate_lambda_managed_policy_attachment: Refreshing state... [id=dns-validate-lambda-role-20210810230926163000000002]
module.dns_validate_lambda_deploy_stack.aws_iam_role_policy_attachment.service_codepipeline_add_policy_attachment: Refreshing state... [id=dns-validator-codepipeline-service-role-20210810230926602600000004]
aws_iam_role.hls_crud_sns_publish_iam_role: Refreshing state... [id=hls-crud-sns-publish-role]
aws_cloudwatch_metric_alarm.deadletter_alarm: Refreshing state... [id=us-east-2-prod dns-validator SQS deadletter queue has message(s)]
module.vidcs_pagerduty.aws_sns_topic_subscription.all_hours_pd_subscription: Refreshing state... [id=arn:aws:sns:us-east-2:625436545767:dns-validator-business-hours-alarm20210811003820403100000002:a93bc575-44be-4013-b1b1-1d15b0bd6a88]
data.aws_iam_policy_document.crud_sanitized_sns_policy_document: Refreshing state...
aws_iam_policy.hls_crud_sns_publish_policy: Refreshing state... [id=arn:aws:iam::625436545767:policy/hls-crud-sns-publish-policy]
data.aws_iam_policy_document.crud_sns_policy_document: Refreshing state...
aws_sqs_queue.dns_validate_delay_queue: Refreshing state... [id=https://sqs.us-east-2.amazonaws.com/625436545767/dns-validate-delay-queue]
aws_cloudwatch_metric_alarm.retry_deadletter_alarm: Refreshing state... [id=us-east-2-prod dns-validator SQS deadletter retry queue has message(s)]
aws_sns_topic_policy.crud_sanitized_topic_policy: Refreshing state... [id=arn:aws:sns:us-east-2:625436545767:ddns-verified-machines]
aws_sns_topic_policy.crud_topic_policy: Refreshing state... [id=arn:aws:sns:us-east-2:625436545767:hls-dns-crud-updater]
aws_sns_topic_subscription.sqs_dns_validate_subscription: Refreshing state... [id=arn:aws:sns:us-east-2:625436545767:hls-dns-crud-updater:4c1845a8-6082-4da0-b10e-002c9271d564]
aws_iam_role_policy_attachment.hls_crud_sns_publish_role_policy_attachment: Refreshing state... [id=hls-crud-sns-publish-role-20210810230926030000000001]
aws_iam_policy.dns_validate_lambda_policy: Refreshing state... [id=arn:aws:iam::625436545767:policy/dns-validate-perms]
aws_lambda_function.dns_validate_lambda: Refreshing state... [id=dns_validate_lambda]
aws_iam_role_policy_attachment.dns_validate_lambda_policy_attachment: Refreshing state... [id=dns-validate-lambda-role-20210810230928820400000006]
aws_sqs_queue_policy.allow_sns_to_send_to_dns_validate: Refreshing state... [id=https://sqs.us-east-2.amazonaws.com/625436545767/dns-validate-queue]
aws_sqs_queue_policy.allow_dns_validate_lambda_to_send_to_retry: Refreshing state... [id=https://sqs.us-east-2.amazonaws.com/625436545767/dns-validate-delay-queue]
aws_lambda_alias.dns_validate_prod_alias: Refreshing state... [id=arn:aws:lambda:us-east-2:625436545767:function:dns_validate_lambda:PROD]
aws_lambda_event_source_mapping.sqs_to_dns_validate: Refreshing state... [id=978ebe99-4cc4-4d96-a922-d559f07657b2]
aws_lambda_event_source_mapping.sqs_to_dns_validate_delay: Refreshing state... [id=7e19b789-0a61-4181-b933-c33ee06d28d1]
module.dns_validate_lambda_deploy_stack.aws_iam_policy.service_codebuild_policy: Refreshing state... [id=arn:aws:iam::625436545767:policy/codebuild-dns-validator-service-policy]
module.dns_validate_lambda_deploy_stack.aws_iam_policy.service_codedeploy_allow: Refreshing state... [id=arn:aws:iam::625436545767:policy/codedeploy-dns-validator-allow]
module.dns_validate_lambda_deploy_stack.aws_codebuild_project.service_codebuild_project: Refreshing state... [id=arn:aws:codebuild:us-east-2:625436545767:project/dns-validator-build]
aws_s3_bucket_object.lambda_zip_to_codesource: Refreshing state... [id=main/SourceArtifact.zip]
module.dns_validate_lambda_deploy_stack.aws_codepipeline.service_codepipeline: Refreshing state... [id=dns-validator-prod-pipeline]
module.dns_validate_lambda_deploy_stack.aws_iam_role_policy_attachment.service_codebuild_policy_attachment: Refreshing state... [id=dns-validator-codebuild-service-role-20210810230933209900000008]
module.dns_validate_lambda_deploy_stack.aws_iam_role_policy_attachment.service_codedeploy_role_extra_policy_attach: Refreshing state... [id=dns-validator-codedeploy-service-role-20210810230933125300000007]
module.slack_sns.aws_sns_topic.pipeline_updates: Refreshing state... [id=arn:aws:sns:us-east-2:625436545767:dns-validator-prod-pipeline-slack-chatbot]
module.slack_sns.data.aws_iam_policy_document.pipeline_updates_policy: Refreshing state...
module.slack_sns.aws_codestarnotifications_notification_rule.pipeline_updates: Refreshing state... [id=arn:aws:codestar-notifications:us-east-2:625436545767:notificationrule/5c3ad4f84387005e5d29f5540f2ce0c57ec2953f]
module.slack_chatbot.aws_cloudformation_stack.slack_chatbot_configuration: Refreshing state... [id=arn:aws:cloudformation:us-east-2:625436545767:stack/codepipeline-slack-chatbot-notification/dfc5e530-0461-11ec-93f9-0267b173ea5e]
module.slack_sns.aws_sns_topic_policy.default: Refreshing state... [id=arn:aws:sns:us-east-2:625436545767:dns-validator-prod-pipeline-slack-chatbot]

------------------------------------------------------------------------

No changes. Infrastructure is up-to-date.

This means that Terraform did not detect any differences between your
configuration and real physical resources that exist. As a result, no
actions need to be performed.
```

# Development

On OS X, the following requirements are available via [homebrew](https://brew.sh/).

* Setup [`pre-commit`](https://pre-commit.com/#install).
* Make sure the following dependencies are installed:
  * [`pre-commit terraform`](https://github.com/antonbabenko/pre-commit-terraform#step-1)
  * [`shellcheck`](https://github.com/koalaman/shellcheck#user-content-installing)

Run `pre-commit install` to install `pre-commit` hook.

## Testing

Unit testing the lambda behavior is supported via `pytest`. To run tests:

1. Setup python virtualenv
1. `pip install -r lambda/requirements.txt-r lambda/requirements-dev.txt`
1. `cd lambda && pytest -v`

### Example test

```python
> pytest -v
=========================================================================== test session starts ===========================================================================
platform darwin -- Python 3.9.6, pytest-6.2.4, py-1.10.0, pluggy-0.13.1 -- /Users/toachris/.virtualenvs/dns-validator/bin/python
cachedir: .pytest_cache
rootdir: /Users/toachris/git/work/video-coreservices/tf-io-hls-dns/src/crud_updater/dns_validator_lambda/lambda
plugins: flake8-1.0.7
collected 10 items

__init__.py::FLAKE8 SKIPPED (file(s) previously passed FLAKE8 checks)                                                                                               [ 10%]
dns_validator.py::FLAKE8 SKIPPED (file(s) previously passed FLAKE8 checks)                                                                                          [ 20%]
tests/__init__.py::FLAKE8 SKIPPED (file(s) previously passed FLAKE8 checks)                                                                                         [ 30%]
tests/conftest.py::FLAKE8 SKIPPED (file(s) previously passed FLAKE8 checks)                                                                                         [ 40%]
tests/test_dns_validator.py::FLAKE8 SKIPPED (file(s) previously passed FLAKE8 checks)                                                                               [ 50%]
tests/test_dns_validator.py::test_handler_ideal PASSED                                                                                                              [ 60%]
tests/test_dns_validator.py::test_handler_delay_bad_ip PASSED                                                                                                       [ 70%]
tests/test_dns_validator.py::test_handler_machine_slow PASSED                                                                                                       [ 80%]
tests/test_dns_validator.py::TestDnsValidator::test_handle_message_no_ip PASSED                                                                                     [ 90%]
tests/test_dns_validator.py::TestDnsValidator::test_sm_determine_delay PASSED                                                                                       [100%]

====================================================================== 5 passed, 5 skipped in 2.68s =======================================================================


```
