// (1 of 2) instantiate the video-org principal destination-policy module
module "video_org_principal_destination" {
  source = "git::git+ssh://git@git.xarth.tv/terraform-modules/video-organization-principal.git//destination?ref=ae591eb"
}

// (2 of 2) include the destination-policy in the trust-policy on your destination iam-role
resource "aws_iam_role" "hls_crud_sns_publish_iam_role" {
  name               = "hls-crud-sns-publish-role"
  assume_role_policy = module.video_org_principal_destination.policy.json
}

# iam policy to be attached to the organization AssumeRole
resource "aws_iam_policy" "hls_crud_sns_publish_policy" {
  name        = "hls-crud-sns-publish-policy"
  path        = "/"
  description = "Policy that allows SNS publish to the CRUD updater topic"
  policy      = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
  {
    "Effect": "Allow",
    "Action": "sns:Publish",
    "Resource": "${aws_sns_topic.crud_updater_topic.arn}"
  }
 ]
}
EOF
}

# attach the policy to the role
resource "aws_iam_role_policy_attachment" "hls_crud_sns_publish_role_policy_attachment" {
  role       = aws_iam_role.hls_crud_sns_publish_iam_role.name
  policy_arn = aws_iam_policy.hls_crud_sns_publish_policy.arn
}

# iam role for dns validator so it can integrate with sqs and push messages to sns
resource "aws_iam_role" "dns_validate_lambda_role" {
  name               = "dns-validate-lambda-role"
  assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
  {
    "Effect": "Allow",
    "Principal": {
      "Service": "lambda.amazonaws.com"
    },
    "Action": "sts:AssumeRole"
  }
 ]
}
EOF
}

resource "aws_iam_policy" "dns_validate_lambda_policy" {
  name        = "dns-validate-perms"
  description = "Allows the dns-validator lambda to talk to the sqs queues and publish to sanitized SNS topic"
  policy      = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Action": [
         "sqs:ReceiveMessage",
         "sqs:DeleteMessage",
         "sqs:GetQueueAttributes"
       ],
      "Resource": [
        "${aws_sqs_queue.dns_validate_queue.arn}",
        "${aws_sqs_queue.dns_validate_delay_queue.arn}"
      ]
    },
    {
      "Effect": "Allow",
      "Action": [
         "sqs:SendMessage"
       ],
      "Resource": "${aws_sqs_queue.dns_validate_delay_queue.arn}"
    },
    {
      "Effect": "Allow",
      "Action": [
         "sns:Publish"
       ],
      "Resource": "${aws_sns_topic.crud_sanitized_topic.arn}"
    },
    {
      "Effect": "Allow",
      "Action": [
        "logs:CreateLogGroup",
        "logs:CreateLogStream",
        "logs:PutLogEvents"
      ],
      "Resource": "*"
    }
  ]
}
EOF
}

resource "aws_iam_role_policy_attachment" "dns_validate_lambda_managed_policy_attachment" {
  role       = aws_iam_role.dns_validate_lambda_role.name
  policy_arn = "arn:aws:iam::aws:policy/service-role/AWSLambdaVPCAccessExecutionRole" # managed role
}

resource "aws_iam_role_policy_attachment" "dns_validate_lambda_policy_attachment" {
  role       = aws_iam_role.dns_validate_lambda_role.name
  policy_arn = aws_iam_policy.dns_validate_lambda_policy.arn
}
