# The lambda that performs validation operations
resource "aws_lambda_function" "dns_validate_lambda" {
  function_name = "dns_validate_lambda"
  filename      = "${path.module}/files/StubLambda.zip" # This intializes the lambda but deploys/changes will be carried out by the push to the S3 codesource.
  role          = aws_iam_role.dns_validate_lambda_role.arn
  handler       = "dns_validator.lambda_handler"
  publish       = true
  runtime       = "python3.7"

  timeout = 60

  vpc_config {
    subnet_ids         = module.shared.private_subnet_ids
    security_group_ids = [module.shared.sg_twitch_subnet_id]
  }

  environment {
    variables = {
      RETRY_QUEUE     = aws_sqs_queue.dns_validate_delay_queue.id
      SANITIZED_TOPIC = aws_sns_topic.crud_sanitized_topic.arn
    }
  }

  lifecycle {
    ignore_changes = [
      # Ignore changes to version and qualified_arn, as those are managed by codedeploy
      qualified_arn,
      version,
    ]
  }
}

# create prod alias
resource "aws_lambda_alias" "dns_validate_prod_alias" {
  name             = "PROD"
  description      = "Alias pointing the lambda to the PROD version"
  function_name    = aws_lambda_function.dns_validate_lambda.arn
  function_version = aws_lambda_function.dns_validate_lambda.version

  lifecycle {
    ignore_changes = [
      # Ignore changes to version, as those are managed by codedeploy
      function_version,
      routing_config,
    ]
  }
}

# default event source mapping
resource "aws_lambda_event_source_mapping" "sqs_to_dns_validate" {
  event_source_arn = aws_sqs_queue.dns_validate_queue.arn
  function_name    = aws_lambda_alias.dns_validate_prod_alias.arn
  batch_size       = 1
}

# delay queue event source mapping
resource "aws_lambda_event_source_mapping" "sqs_to_dns_validate_delay" {
  event_source_arn = aws_sqs_queue.dns_validate_delay_queue.arn
  function_name    = aws_lambda_alias.dns_validate_prod_alias.arn
  batch_size       = 1
}
