import boto3
import os
import pytest

from moto import mock_sqs, mock_sns

AWS_REGION = "us-west-2"


@pytest.fixture
def aws_credentials():
    """Mocked AWS Credentials for moto."""
    os.environ["AWS_ACCESS_KEY_ID"] = "testing"
    os.environ["AWS_SECRET_ACCESS_KEY"] = "testing"
    os.environ["AWS_SECURITY_TOKEN"] = "testing"
    os.environ["AWS_SESSION_TOKEN"] = "testing"


@pytest.fixture
def sqs_client(aws_credentials):
    with mock_sqs():
        conn = boto3.client("sqs", region_name=os.environ.get("AWS_REGION"))
        yield conn


@pytest.fixture
def sns_client(aws_credentials):
    with mock_sns():
        conn = boto3.client("sns", region_name=os.environ.get('AWS_REGION'))
        yield conn
