# TODO: Add wiki link runbook
module "vidcs_pagerduty" {
  source       = "git@git.xarth.tv:video-coreservices/tf-mod-sns-subscription.git?ref=v1.0.0"
  service_name = local.common_tags["Service"]
}

resource "aws_cloudwatch_metric_alarm" "deadletter_alarm" {
  actions_enabled = var.env == "prod" ? true : false

  alarm_name          = "${var.region}-${var.env} ${local.common_tags["Service"]} SQS deadletter queue has message(s)"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = "2"
  metric_name         = "ApproximateNumberOfMessagesVisible"
  namespace           = "AWS/SQS"
  statistic           = "Sum"
  period              = "60"
  threshold           = "1"
  alarm_description   = "${var.region}-${var.env} ${local.common_tags["Service"]} SQS deadletter queue has message(s)."
  alarm_actions       = [module.vidcs_pagerduty.business_hours_topic_arn]
  ok_actions          = [module.vidcs_pagerduty.business_hours_topic_arn]

  dimensions = {
    QueueName = aws_sqs_queue.dns_validate_deadletter.name
  }
}

resource "aws_cloudwatch_metric_alarm" "retry_deadletter_alarm" {
  actions_enabled = var.env == "prod" ? true : false

  alarm_name          = "${var.region}-${var.env} ${local.common_tags["Service"]} SQS deadletter retry queue has message(s)"
  comparison_operator = "GreaterThanOrEqualToThreshold"
  evaluation_periods  = "2"
  metric_name         = "ApproximateNumberOfMessagesVisible"
  namespace           = "AWS/SQS"
  statistic           = "Sum"
  period              = "60"
  threshold           = "1"
  alarm_description   = "${var.region}-${var.env} ${local.common_tags["Service"]} SQS deadletter retry queue has message(s)."
  alarm_actions       = [module.vidcs_pagerduty.business_hours_topic_arn]
  ok_actions          = [module.vidcs_pagerduty.business_hours_topic_arn]

  dimensions = {
    QueueName = aws_sqs_queue.dns_validate_delay_deadletter.name
  }
}

# Allow CW on w.amazon.com
module "cloudwatch_wiki" {
  source = "git@git.xarth.tv:video-coreservices/tf-mod-cloudwatchdashboards-wiki.git?ref=v1.1.1"
}
