variable "env" {
  description = "Service environment - (prod|staging)"
  default     = "staging"
}

variable "region" {
  description = "The AWS region this service will be deployed"
  default     = "us-west-2"
}

locals {
  # dns-validator staging (for staging testing)
  # --------------
  # 152548578290 twitch-bs-video-ops-stg@amazon.com
  #
  # hls.live-video.net dns-updater
  # --------------
  # 873126202975 twitch-vidcs+hls-lv-net-edgeupdate-prod-us-east-2@amazon.com
  # 398750410825 twitch-vidcs+hls-lv-net-edgeupdate-prod-us-west-2@amazon.com
  # 522498341573 twitch-vidcs+hls-lv-net-edgeupdate-staging-us-west-2@amazon.com
  #
  # warp.live-video.net dns-updater
  # --------------
  # 618029135405 twitch-warp-dns+edgeupdate-prod-us-east-2@amazon.com
  # 733068333177 twitch-warp-dns+edgeupdate-prod-us-west-2@amazon.com
  # 410778197068 twitch-warp-dns+edgeupdate-staging-us-west-2@amazon.com
  #
  # hls.ttvnw.net dns-updater
  # --------------
  # 599087406594 twitch-vidcs+hls-ttvnw-net-edgeupdate-prod-us-east-2@amazon.com
  # 102890704200 twitch-vidcs+hls-ttvnw-net-edgeupdate-prod-us-west-2@amazon.com
  # 007812478044 twitch-vidcs+hls-ttvnw-net-edgeupdate-staging-usw2@amazon.com
  cross_account_subs = {
    prod = {
      us-east-2 = [
        "arn:aws:iam::873126202975:root", # 873126202975 twitch-vidcs+hls-lv-net-edgeupdate-prod-us-east-2@amazon.com
        "arn:aws:iam::618029135405:root", # 618029135405 twitch-warp-dns+edgeupdate-prod-us-east-2@amazon.com
        "arn:aws:iam::599087406594:root", # 599087406594 twitch-vidcs+hls-ttvnw-net-edgeupdate-prod-us-east-2@amazon.com
      ],
      us-west-2 = [
        "arn:aws:iam::398750410825:root", # 398750410825 twitch-vidcs+hls-lv-net-edgeupdate-prod-us-west-2@amazon.com
        "arn:aws:iam::733068333177:root", # 733068333177 twitch-warp-dns+edgeupdate-prod-us-west-2@amazon.com
        "arn:aws:iam::410778197068:root", # 410778197068 twitch-warp-dns+edgeupdate-staging-us-west-2@amazon.com
        "arn:aws:iam::102890704200:root", # 102890704200 twitch-vidcs+hls-ttvnw-net-edgeupdate-prod-us-west-2@amazon.com
        "arn:aws:iam::007812478044:root", # 007812478044 twitch-vidcs+hls-ttvnw-net-edgeupdate-staging-usw2@amazon.com
      ]
    }
    staging = {
      us-west-2 = [
        "arn:aws:iam::152548578290:root", # 152548578290 twitch-bs-video-ops-stg@amazon.com
        "arn:aws:iam::522498341573:root", # 398750410825 twitch-vidcs+hls-lv-net-edgeupdate-staging-us-west-2@amazon.com
      ]
    }
  }

  common_tags = {
    Owner       = "video-coreservices@twitch.tv"
    Service     = "dns-validator"
    Environment = var.env
    Source      = "video-coreservices/tf-io-ddns-validator/src/dns_validator_lambda"
  }
}
