variable "region" {
  default = "us-west-2"
}

variable "env" {
  default = "prod"
}

variable "vpc_id" {
  type = map

  default = {
    prod = {
      us-west-2 = "vpc-04b862601a1a0d9a0"
      us-east-2 = "vpc-0e45c099cd0e2dd6c"
    }
    staging = {
      us-west-2 = "vpc-52e02435"
    }
  }
}

variable "sg_twitch_subnet_id" {
  type = map

  default = {
    prod = {
      us-west-2 = "sg-0facf2240f7f19fef" # twitch_subnets
      us-east-2 = "sg-0d0c57877213efbc4"
    }
    staging = {
      us-west-2 = "sg-5733632e" # twitch_subnets
    }
  }
}

variable "private_subnet_ids" {
  type = map

  default = {
    prod = {
      us-west-2 = ["subnet-0b09ee40d881de02e", "subnet-0ca401dee351666ed", "subnet-090e2ab0de9af74b4", "subnet-081e941a9f8fc908c"]
      us-east-2 = ["subnet-074f1dde2d06ab3e8", "subnet-0133763b962b26619", "subnet-0552d5eb3b85ff0aa"]
    }
    staging = {
      us-west-2 = ["subnet-7fc12018", "subnet-d42f14a2", "subnet-28790d70"]
    }
  }
}
