# Unbound (dns-resolver) Monitoring and Alerting

This code manages the setup of cloudwatch alarms for [dns-resolver](https://wiki.twitch.com/display/VID/DNS+Resolver) logs ingestion and servfails.

* [DNSTAP Logs Ingestion Rate](./src/dnstap-ingestion-rate)
* [SERVFAILs on IVS specific domains](./src/dns-servfails)

# Usage

<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->


- [Requirements](#requirements)
- [Deployment](#deployment)
- [Development](#development)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->

## Requirements

* [tfenv](https://github.com/tfutils/tfenv#automatic)
* AWS credentials dependent on monitoring as data ingested in different accounts.
  * [DNSTAP Logs Ingestion Rate](./src/dnstap-ingestion-rate) - `Admin` role of [twitch-video-aws@amazon.com (848744099708)](https://isengard.amazon.com/console-access) account.
  * [SERVFAILs on IVS specific domains](./src/dns-servfails) - `Admin` role of [twitch-bs-video-ops-aws@amazon.com (277437172290)](https://isengard.amazon.com/console-access) account.

## Deployment

Standard terraform arguments. E.g. `plan|apply|...`. E.g.

1. `./deploy.sh plan`
1. `./deploy.sh apply`

## Development

On OS X, the following requirements are available via [homebrew](https://brew.sh/).

* Setup [`pre-commit`](https://pre-commit.com/#install).
* Make sure the following dependencies are installed:
  * [`pre-commit terraform`](https://github.com/antonbabenko/pre-commit-terraform#step-1)

Run `pre-commit install` to install `pre-commit` hook.
