terraform {
  required_version = "=0.12.26"

  backend "s3" {
    region         = "us-west-2"
    dynamodb_table = "terraform_locks"
    bucket         = "twitch-video-ops-aws-tf-state"
    key            = "tf-io-dns-logs-monitoring/dns-servfails/terraform.tfstate"
  }
}

provider "aws" {
  region  = "us-west-2"
  version = "~> 2.70"
}

provider "aws" {
  region = "us-west-2"
  alias  = "us-west-2"
}

provider "aws" {
  region = "us-east-2"
  alias  = "us-east-2"
}

provider "aws" {
  region = "eu-west-1"
  alias  = "eu-west-1"
}

provider "null" {
  version = "~> 2.1.2"
}

# Validate account and role to perform changes
data "aws_caller_identity" "current" {}

resource "null_resource" "validate_role" {
  count = element(split("/", data.aws_caller_identity.current.arn), 1) == "Admin" ? 0 : "Please assume the Admin role in twitch-video-aws@amazon.com account"
}
