terraform {
  required_version = "=0.12.26"

  backend "s3" {
    region         = "us-west-2"
    dynamodb_table = "terraform_locks"
    bucket         = "twitch-video-terraform"
    key            = "tf-io-dns-logs-monitoring/terraform.tfstate"
  }
}

# Stub us-west-2 since it's a required parameter
provider "aws" {
  region  = "us-west-2"
  version = "~> 2.65"
}

provider "null" {
  version = "~> 2.1.2"
}

# Validate account and role to perform changes
data "aws_caller_identity" "current" {}

resource "null_resource" "validate_role" {
  count = element(split("/", data.aws_caller_identity.current.arn), 1) == "Admin" ? 0 : "Please assume the Admin role in twitch-video-aws@amazon.com account"
}

resource "null_resource" "validate_account" {
  count = data.aws_caller_identity.current.account_id == "848744099708" ? 0 : "Please assume the Admin role in twitch-video-aws@amazon.com account"
}
