# Manages all pop based delegations domains

This code provides a single location to manage `pop` type delegations of domains under VidCS management. E.g. `<pop>.hls.live-video.net`, `<pop>.abs.hls.ttvnw.net`, etc.

The `dns-admin` role has been setup with permissions to assume `dns-pop-delegation-control` in the various other DNS accounts to be able to perform the necessary DNS configurations and delegations. This code does the following:

1. Assume the correct role of the respective DNS accounts.
1. Create `pop` based hosted zones
1. Delegate `pop` hosted zone from the _primary/root_ domain.
1. Configure query logging for the respective `pop` zones.

The terraform state files are isolated by `pop`, stored in S3 bucket owned by `362079722421` account (i.e. same account where `dns-admin` role is setup).

**Note: The `dns-admin` role and policies is solely managed in Isengard.**

## Usage

<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->


- [Domains Supported](#domains-supported)
  - [IVS based domains](#ivs-based-domains)
  - [Twitch based domains](#twitch-based-domains)
- [Requirements](#requirements)
- [Deployment](#deployment)
  - [Steps](#steps)
  - [Example plan](#example-plan)
- [Development](#development)
- [Configuring new domains](#configuring-new-domains)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->
## Domains Supported

The following domains are supported today:

### IVS based domains
* `hls.live-video.net`
* `warp.live-video.net`

### Twitch based domains
* `hls.ttvnw.net`
* `abs.hls.ttvnw.net`
* `no-abs.hls.ttvnw.net`


## Requirements

1. AWS credentials to assume `dns-admin` role of [twitch-vidcs+pop-delegation-control-dns@amazon.com (362079722421)](https://isengard.amazon.com/console-access) account.


## Deployment

A list of valid pops is maintained in [`tf-mod-datacenters-metadata`](https://git.xarth.tv/video-coreservices/tf-mod-datacenters-metadata) that no accidental pops are delegated. If a new pop is required, please update [`tf-mod-datacenters-metadata`](https://git.xarth.tv/video-coreservices/tf-mod-datacenters-metadata).

### Steps

1. Export `dns-admin` temporary credentials. E.g. via [`isengardcli`](https://w.amazon.com/bin/view/Isengard-cli/)
   ```bash
   # isengardcli
   isengardcli creds twitch-vidcs+pop-delegation-control-dns --role dns-admin
   ```
1. Run `./deploy.sh -p <new_pop> plan`.
1. Validate intended change.
1. Run `./deploy.sh -p <new_pop> apply`.

### Example plan

```bash
> ./deploy.sh -p sjc03 plan
Initializing modules...

Initializing the backend...

Successfully configured the backend "s3"! Terraform will automatically
use this backend unless the backend configuration changes.

Initializing provider plugins...
- Reusing previous version of hashicorp/aws from the dependency lock file
- Reusing previous version of hashicorp/null from the dependency lock file
- Using previously-installed hashicorp/aws v3.58.0
- Using previously-installed hashicorp/null v3.1.0

Terraform has been successfully initialized!

You may now begin working with Terraform. Try running "terraform plan" to see
any changes that are required for your infrastructure. All Terraform commands
should now work.

If you ever set or change modules or backend configuration for Terraform,
rerun this command to reinitialize your working directory. If you forget, other
commands will detect it and remind you to do so if necessary.

Terraform used the selected providers to generate the following execution plan. Resource actions are indicated with the following symbols:
  + create

Terraform will perform the following actions:

  # module.hls_lvs_net.aws_route53_query_log.subdomain_query_log["sjc03.hls.live-video.net"] will be created
  + resource "aws_route53_query_log" "subdomain_query_log" {
      + arn                      = (known after apply)
      + cloudwatch_log_group_arn = "arn:aws:logs:us-east-1:393787499934:log-group:/aws/route53/hls-live-video-net-query-logs"
      + id                       = (known after apply)
      + zone_id                  = (known after apply)
    }

  # module.hls_lvs_net.aws_route53_record.soa["sjc03.hls.live-video.net"] will be created
  + resource "aws_route53_record" "soa" {
      + allow_overwrite = true
      + fqdn            = (known after apply)
      + id              = (known after apply)
      + name            = "sjc03.hls.live-video.net"
      + records         = (known after apply)
      + ttl             = 900
      + type            = "SOA"
      + zone_id         = (known after apply)
    }

  # module.hls_lvs_net.aws_route53_record.subdomain["sjc03.hls.live-video.net"] will be created
  + resource "aws_route53_record" "subdomain" {
      + allow_overwrite = (known after apply)
      + fqdn            = (known after apply)
      + id              = (known after apply)
      + name            = "sjc03.hls.live-video.net"
      + records         = (known after apply)
      + ttl             = 86400
      + type            = "NS"
      + zone_id         = "Z1GWR9CZ1GXJEY"
    }

  # module.hls_lvs_net.aws_route53_zone.subdomain["sjc03.hls.live-video.net"] will be created
  + resource "aws_route53_zone" "subdomain" {
      + arn           = (known after apply)
      + comment       = "sjc03 delegation"
      + force_destroy = false
      + id            = (known after apply)
      + name          = "sjc03.hls.live-video.net"
      + name_servers  = (known after apply)
      + tags_all      = {
          + "Environment" = "prod"
          + "Owner"       = "video-coreservices@twitch.tv"
          + "Service"     = "hls-dns"
          + "Src"         = "video-coreservices/tf-io-hls-dns"
        }
      + zone_id       = (known after apply)
    }

  # module.hls_ttvnw_net.aws_route53_query_log.subdomain_query_log["sjc03.abs.hls.ttvnw.net"] will be created
  + resource "aws_route53_query_log" "subdomain_query_log" {
      + arn                      = (known after apply)
      + cloudwatch_log_group_arn = "arn:aws:logs:us-east-1:707969931081:log-group:/aws/route53/hls-ttvnw-net-query-logs"
      + id                       = (known after apply)
      + zone_id                  = (known after apply)
    }

  # module.hls_ttvnw_net.aws_route53_query_log.subdomain_query_log["sjc03.hls.ttvnw.net"] will be created
  + resource "aws_route53_query_log" "subdomain_query_log" {
      + arn                      = (known after apply)
      + cloudwatch_log_group_arn = "arn:aws:logs:us-east-1:707969931081:log-group:/aws/route53/hls-ttvnw-net-query-logs"
      + id                       = (known after apply)
      + zone_id                  = (known after apply)
    }

  # module.hls_ttvnw_net.aws_route53_query_log.subdomain_query_log["sjc03.no-abs.hls.ttvnw.net"] will be created
  + resource "aws_route53_query_log" "subdomain_query_log" {
      + arn                      = (known after apply)
      + cloudwatch_log_group_arn = "arn:aws:logs:us-east-1:707969931081:log-group:/aws/route53/hls-ttvnw-net-query-logs"
      + id                       = (known after apply)
      + zone_id                  = (known after apply)
    }

  # module.hls_ttvnw_net.aws_route53_record.soa["sjc03.abs.hls.ttvnw.net"] will be created
  + resource "aws_route53_record" "soa" {
      + allow_overwrite = true
      + fqdn            = (known after apply)
      + id              = (known after apply)
      + name            = "sjc03.abs.hls.ttvnw.net"
      + records         = (known after apply)
      + ttl             = 900
      + type            = "SOA"
      + zone_id         = (known after apply)
    }

  # module.hls_ttvnw_net.aws_route53_record.soa["sjc03.hls.ttvnw.net"] will be created
  + resource "aws_route53_record" "soa" {
      + allow_overwrite = true
      + fqdn            = (known after apply)
      + id              = (known after apply)
      + name            = "sjc03.hls.ttvnw.net"
      + records         = (known after apply)
      + ttl             = 900
      + type            = "SOA"
      + zone_id         = (known after apply)
    }

  # module.hls_ttvnw_net.aws_route53_record.soa["sjc03.no-abs.hls.ttvnw.net"] will be created
  + resource "aws_route53_record" "soa" {
      + allow_overwrite = true
      + fqdn            = (known after apply)
      + id              = (known after apply)
      + name            = "sjc03.no-abs.hls.ttvnw.net"
      + records         = (known after apply)
      + ttl             = 900
      + type            = "SOA"
      + zone_id         = (known after apply)
    }

  # module.hls_ttvnw_net.aws_route53_record.subdomain["sjc03.abs.hls.ttvnw.net"] will be created
  + resource "aws_route53_record" "subdomain" {
      + allow_overwrite = (known after apply)
      + fqdn            = (known after apply)
      + id              = (known after apply)
      + name            = "sjc03.abs.hls.ttvnw.net"
      + records         = (known after apply)
      + ttl             = 86400
      + type            = "NS"
      + zone_id         = "Z08378525UZ9H4ASZ101"
    }

  # module.hls_ttvnw_net.aws_route53_record.subdomain["sjc03.hls.ttvnw.net"] will be created
  + resource "aws_route53_record" "subdomain" {
      + allow_overwrite = (known after apply)
      + fqdn            = (known after apply)
      + id              = (known after apply)
      + name            = "sjc03.hls.ttvnw.net"
      + records         = (known after apply)
      + ttl             = 86400
      + type            = "NS"
      + zone_id         = "Z08378525UZ9H4ASZ101"
    }

  # module.hls_ttvnw_net.aws_route53_record.subdomain["sjc03.no-abs.hls.ttvnw.net"] will be created
  + resource "aws_route53_record" "subdomain" {
      + allow_overwrite = (known after apply)
      + fqdn            = (known after apply)
      + id              = (known after apply)
      + name            = "sjc03.no-abs.hls.ttvnw.net"
      + records         = (known after apply)
      + ttl             = 86400
      + type            = "NS"
      + zone_id         = "Z08378525UZ9H4ASZ101"
    }

  # module.hls_ttvnw_net.aws_route53_zone.subdomain["sjc03.abs.hls.ttvnw.net"] will be created
  + resource "aws_route53_zone" "subdomain" {
      + arn           = (known after apply)
      + comment       = "sjc03.abs delegation"
      + force_destroy = false
      + id            = (known after apply)
      + name          = "sjc03.abs.hls.ttvnw.net"
      + name_servers  = (known after apply)
      + tags_all      = {
          + "Environment" = "prod"
          + "Owner"       = "video-coreservices@twitch.tv"
          + "Service"     = "hls.ttvnw.net-dns"
          + "Src"         = "video-coreservices/tf-io-hls-ttvnw-net-dns"
        }
      + zone_id       = (known after apply)
    }

  # module.hls_ttvnw_net.aws_route53_zone.subdomain["sjc03.hls.ttvnw.net"] will be created
  + resource "aws_route53_zone" "subdomain" {
      + arn           = (known after apply)
      + comment       = "sjc03 delegation"
      + force_destroy = false
      + id            = (known after apply)
      + name          = "sjc03.hls.ttvnw.net"
      + name_servers  = (known after apply)
      + tags_all      = {
          + "Environment" = "prod"
          + "Owner"       = "video-coreservices@twitch.tv"
          + "Service"     = "hls.ttvnw.net-dns"
          + "Src"         = "video-coreservices/tf-io-hls-ttvnw-net-dns"
        }
      + zone_id       = (known after apply)
    }

  # module.hls_ttvnw_net.aws_route53_zone.subdomain["sjc03.no-abs.hls.ttvnw.net"] will be created
  + resource "aws_route53_zone" "subdomain" {
      + arn           = (known after apply)
      + comment       = "sjc03.no-abs delegation"
      + force_destroy = false
      + id            = (known after apply)
      + name          = "sjc03.no-abs.hls.ttvnw.net"
      + name_servers  = (known after apply)
      + tags_all      = {
          + "Environment" = "prod"
          + "Owner"       = "video-coreservices@twitch.tv"
          + "Service"     = "hls.ttvnw.net-dns"
          + "Src"         = "video-coreservices/tf-io-hls-ttvnw-net-dns"
        }
      + zone_id       = (known after apply)
    }

  # module.warp_lvs_net.aws_route53_query_log.subdomain_query_log["sjc03.warp.live-video.net"] will be created
  + resource "aws_route53_query_log" "subdomain_query_log" {
      + arn                      = (known after apply)
      + cloudwatch_log_group_arn = "arn:aws:logs:us-east-1:804916306882:log-group:/aws/route53/warp-live-video-net-query-logs"
      + id                       = (known after apply)
      + zone_id                  = (known after apply)
    }

  # module.warp_lvs_net.aws_route53_record.soa["sjc03.warp.live-video.net"] will be created
  + resource "aws_route53_record" "soa" {
      + allow_overwrite = true
      + fqdn            = (known after apply)
      + id              = (known after apply)
      + name            = "sjc03.warp.live-video.net"
      + records         = (known after apply)
      + ttl             = 900
      + type            = "SOA"
      + zone_id         = (known after apply)
    }

  # module.warp_lvs_net.aws_route53_record.subdomain["sjc03.warp.live-video.net"] will be created
  + resource "aws_route53_record" "subdomain" {
      + allow_overwrite = (known after apply)
      + fqdn            = (known after apply)
      + id              = (known after apply)
      + name            = "sjc03.warp.live-video.net"
      + records         = (known after apply)
      + ttl             = 86400
      + type            = "NS"
      + zone_id         = "Z08845921QN18TGF9V65U"
    }

  # module.warp_lvs_net.aws_route53_zone.subdomain["sjc03.warp.live-video.net"] will be created
  + resource "aws_route53_zone" "subdomain" {
      + arn           = (known after apply)
      + comment       = "sjc03 delegation"
      + force_destroy = false
      + id            = (known after apply)
      + name          = "sjc03.warp.live-video.net"
      + name_servers  = (known after apply)
      + tags_all      = {
          + "Environment" = "prod"
          + "Owner"       = "video-coreservices@twitch.tv"
          + "Service"     = "warp-dns"
          + "Src"         = "video-coreservices/tf-io-warp-dns"
        }
      + zone_id       = (known after apply)
    }

Plan: 20 to add, 0 to change, 0 to destroy.

Changes to Outputs:
  + delegated_pop_zones = {
      + sjc03.abs.hls.ttvnw.net    = {
          + id           = (known after apply)
          + name         = "sjc03.abs.hls.ttvnw.net"
          + name_servers = (known after apply)
          + ttl          = 86400
        }
      + sjc03.hls.live-video.net   = {
          + id           = (known after apply)
          + name         = "sjc03.hls.live-video.net"
          + name_servers = (known after apply)
          + ttl          = 86400
        }
      + sjc03.hls.ttvnw.net        = {
          + id           = (known after apply)
          + name         = "sjc03.hls.ttvnw.net"
          + name_servers = (known after apply)
          + ttl          = 86400
        }
      + sjc03.no-abs.hls.ttvnw.net = {
          + id           = (known after apply)
          + name         = "sjc03.no-abs.hls.ttvnw.net"
          + name_servers = (known after apply)
          + ttl          = 86400
        }
      + sjc03.warp.live-video.net  = {
          + id           = (known after apply)
          + name         = "sjc03.warp.live-video.net"
          + name_servers = (known after apply)
          + ttl          = 86400
        }
    }
```

## Development

On OS X, the following requirements are available via [homebrew](https://brew.sh/).

* Setup [`pre-commit`](https://pre-commit.com/#install).
* Make sure the following dependencies are installed:
  * [`pre-commit terraform`](https://github.com/antonbabenko/pre-commit-terraform#step-1)
  * [`shellcheck`](https://github.com/koalaman/shellcheck#user-content-installing)

Run `pre-commit install` to install `pre-commit` hook.

## Configuring new domains

The delegation logic has mostly been refactored to [`./modules/delegate`](./modules/delegate). To manage additional domains:

1. Refer to one of the `pop_*.tf` files, e.g. [`pop_hls_ttvnw_net.tf`](./pop_hls_ttvnw_net.tf).
1. Create another file, and substitute the values as necessary.
