terraform {
  required_version = "=1.0.7"

  required_providers {
    aws = {}
  }

  backend "s3" {
    region         = "us-east-1"
    dynamodb_table = "terraform_locks"
    bucket         = "pop-delegation-control-dns-us-east-1-prod-tf-state"
  }
}

provider "aws" {
  allowed_account_ids = local.allowed_account_ids
  region              = local.region
}

data "aws_caller_identity" "current" {}

# Validate pops
# Only manage pops that are explicitly specified
module "datacenters" {
  source = "git@git.xarth.tv:video-coreservices/tf-mod-datacenters-metadata.git"
}

resource "null_resource" "validate_pop" {
  count = contains(concat(module.datacenters.all_datacenters, ["staging"]), var.pop) == true ? 0 : "This is not a valid pop. If this is a new pop, update tf-mod-datacenters-metadata module"
}
