terraform {
  required_providers {
    aws = {}
  }
}

data "aws_caller_identity" "current" {}

########################
# Create subdomain zone
########################
resource "aws_route53_zone" "subdomain" {
  for_each = local.subdomain_names

  name    = each.key
  comment = "${replace(each.key, ".${var.domain}", "")} delegation"

  force_destroy = false
}

# AWS default SOA timings does not work for our use case
resource "aws_route53_record" "soa" {
  for_each = local.subdomain_names

  allow_overwrite = true

  zone_id = aws_route53_zone.subdomain[each.key].id
  name    = each.key
  type    = "SOA"
  ttl     = 900

  # The 3rd element (instead of the 1st) is somehow always the nameserver that we want to match with the default
  # created Route53 SOA record. Don't ask why. ¯\_(ツ)_/¯
  # Route53 default: <name_server> awsdns-hostmaster.amazon.com. 1 7200 900 1209600 86400
  records = [
    "${aws_route53_zone.subdomain[each.key].name_servers.2}. awsdns-hostmaster.amazon.com. 1 7200 900 1209600 900"
  ]
}

# enable query logging
resource "aws_route53_query_log" "subdomain_query_log" {
  for_each = local.subdomain_names

  cloudwatch_log_group_arn = "arn:aws:logs:us-east-1:${data.aws_caller_identity.current.account_id}:log-group:${var.cloudwatch_log_group}"
  zone_id                  = aws_route53_zone.subdomain[each.key].zone_id
}

###################################
# Delegate from main domain
###################################
data "aws_route53_zone" "primary" {
  name = var.domain
}

resource "aws_route53_record" "subdomain" {
  for_each = local.subdomain_names

  zone_id = data.aws_route53_zone.primary.zone_id
  name    = each.key
  type    = "NS"
  ttl     = local.ttl

  records = aws_route53_zone.subdomain[each.key].name_servers
}
