variable "pop" {
  type        = string
  description = "The pop name. E.g. ord03, sjc05, ..."
}

variable "domain" {
  type        = string
  description = "The name of the main domain"
}

variable "addl_subdomain_prefixes" {
  type        = list(string)
  description = "A list of additional subdomains prefix that should have pop delegations. E.g. abs, no-abs"
  default     = []
}

variable "cloudwatch_log_group" {
  type        = string
  description = "The cloudwatch log group arn for Route53 to write logs to"
}

locals {
  ttl = 86400 # 1 day DNS delegation ttl

  subdomain_names = toset(concat(
    ["${var.pop}.${var.domain}"],
    formatlist("${var.pop}.%s.${var.domain}", var.addl_subdomain_prefixes),
  ))
}
