provider "aws" {
  alias  = "hls_lvs_net"
  region = local.region

  assume_role {
    role_arn     = "arn:aws:iam::393787499934:role/dns-pop-delegation-control"
    session_name = "hls.live-video.net"
  }

  default_tags {
    # Maintain default tags for migration
    tags = merge(local.default_tags, {
      Service = "hls-dns"
    })
  }
}

module "hls_lvs_net" {
  source = "./modules/delegate"

  providers = {
    aws = aws.hls_lvs_net
  }

  pop    = var.pop
  domain = "hls.live-video.net"

  cloudwatch_log_group = "/aws/route53/hls-live-video-net-query-logs"
}
