provider "aws" {
  alias  = "hls_ttvnw_net"
  region = local.region

  assume_role {
    role_arn     = "arn:aws:iam::707969931081:role/dns-pop-delegation-control"
    session_name = "hls.ttvnw.net"
  }

  default_tags {
    # Maintain default tags for migration
    tags = merge(local.default_tags, {
      Service = "hls.ttvnw.net-dns"
    })
  }
}

module "hls_ttvnw_net" {
  source = "./modules/delegate"

  providers = {
    aws = aws.hls_ttvnw_net
  }

  pop    = var.pop
  domain = "hls.ttvnw.net"
  addl_subdomain_prefixes = [
    "abs",
    "no-abs",
  ]

  cloudwatch_log_group = "/aws/route53/hls-ttvnw-net-query-logs"
}
