provider "aws" {
  alias  = "warp_lvs_net"
  region = local.region

  assume_role {
    role_arn     = "arn:aws:iam::804916306882:role/dns-pop-delegation-control"
    session_name = "warp.live-video.net"
  }

  default_tags {
    # Maintain default tags for migration
    tags = merge(local.default_tags, {
      Service = "warp-dns"
    })
  }
}

module "warp_lvs_net" {
  source = "./modules/delegate"

  providers = {
    aws = aws.warp_lvs_net
  }

  pop    = var.pop
  domain = "warp.live-video.net"

  cloudwatch_log_group = "/aws/route53/warp-live-video-net-query-logs"
}
