variable "pop" {
  type        = string
  description = "The pop name. E.g. ord03, sjc05, ..."
}

locals {
  # Route53 global really means us-east-1
  region = "us-east-1"

  # Another paranoia protection to use the correct account
  # twitch-vidcs+pop-delegation-control-dns
  allowed_account_ids = ["362079722421"]

  default_tags = {
    Owner       = "video-coreservices@twitch.tv"
    Environment = "prod"
    Src         = "video-coreservices/tf-io-dns-pop-delegation"
  }
}
