# Ganglia Production Terraform

This code manages the creation and deployment of ganglia cluster.

* Prod:
  * https://ganglia.xarth.tv
  * https://ganglia.prod.vidops.twitch.a2z.com
* Stage: https://ganglia.stage.vidops.twitch.a2z.com

# Usage

## Requirements
* [terrafile](https://github.com/coretech/terrafile#how-to-install)
* [tfenv](https://github.com/tfutils/tfenv#automatic)
* [aws-tools](https://git-aws.internal.justin.tv/systems/aws-tools)
* AWS credentials to intended [prod/stage](https://isengard.amazon.com/console-access) accounts
  * Prod: twitch-bs-video-ops-aws@amazon.com
  * Stage: twitch-bs-video-ops-stg@amazon.com

## Deployment

To deploy terraform changes:

* `./deploy.sh -e <stage|prod> <plan|apply> ...`

## Attaching / Detaching ENI

When provisioning/rebuilding an instance, this ENI has to be attached to the new host. This is done via  [`eni_maint.sh`](https://git-aws.internal.justin.tv/systems/aws-tools/blob/master/bin/eni_maint.sh). If this is not done, the ENI interface is not setup on the host and it will not receive gmond traffic from hosts.

Usage:
```
./bin/eni_maint.sh -r <region> -i <instance_id> -n <eni_id> -d <eni_id>
```

Example:
```
./bin/eni_maint.sh -r us-west-2 -i i-04a4cb903beabddda -n eni-0d380e158719da9ac -d eni-0d380e158719da9ac
```

## Syncing data from another instance

A newly provisioned instance does not have any data. To sync data from an existing instance to the new host:

New target ganglia instance:

```
$ sudo apt install mbuffer pigz
$ cd /var/lib/ganglia/rrds/
$ sudo mbuffer -m 3G -P0.1 -I 443 -4 -s 1M | pigz -d -p16 | pv -brat | sudo tar -x
```

Source ganglia instance:

```
$ sudo apt install mbuffer pigz
$ cd /var/lib/ganglia/rrds/
$ tar -c * | pv -brates 376G | pigz -3 -c -p16 | sudo mbuffer -m3G -s1M -P0.1 -4 -O <new_target>:443 [ -O <new_target2>:443 -O <new_target3> ... ]
```

## Notes

* Certificate for ganglia.xarth.tv is managed manually via ACM
* ganglia.xarth.tv ALIAS is managed manually via Route53 console

# Others

## TODO:

* Merge updated code for aws_instance module

## Nice to have

* Wrap deployment into a separate repo and pull in via subtree.
* Wrap deployment in a docker container.
