# Required inputs
variable "ssl_domain" {
  description = "SSL domain name to lookup to attach cert to ALB"
}

# Optional inputs
variable "env" {
  description = "Service environment - (prod|stage)"
  default     = "stage"
}

variable "region" {
  description = "The AWS region this service will be deployed"
  default     = "us-west-2"
}

variable "instance_type" {
  description = "EC2 instance type this service will be running on"
  default     = "i3.4xlarge"
}

variable "instance_count" {
  description = "Number of instances to run"
  default     = 1
}

variable "ami_id" {
  description = "Custom AMI ID"
  default     = ""
}

# Legacy mappings of environment long names
locals {
  environment_map = {
    prod  = "production"
    stage = "staging"
    dev   = "development"
  }

  environment = "${local.environment_map[var.env]}"
}
