#!/usr/bin/env bash

set -eo pipefail

usage() {
    echo "Usage: $0 -e <stage|prod> <command> [args]"
    exit 1
}

requirements() {
    command -v tfenv &> /dev/null || ( echo "tfenv required but missing" && usage )
}

tf_init() {
    shift

    # tf 0.12 resolves symlink path path and writes it to this file instead
    rm -f .terraform/modules/modules.json

    terraform init "$@" -reconfigure -backend-config="conf/${env}/backend.tfvars"
}

[[ "$1" == "-e" && "$2" =~ ^stage$|^prod$ ]] || usage

env="$2"
shift 2

requirements

case "$1" in
    init)
        tf_init "$@"
        ;;
    plan|apply)
        tf_init "$@"
        exec terraform "$@" \
            -var-file="conf/${env}/variables.tfvars"
        ;;
    destroy)
        exec terraform "$@" \
            -var-file="conf/${env}/variables.tfvars"
        ;;
    *)
        exec terraform "$@"
        ;;
esac
