variable "graphite_subnets" {
  description = "Subnets for the graphite infrastructure"
}

variable "go_carbon_node_count" {
  description = "Number of nodes in the go-carbon cluster"
}

variable "graphite_web_node_count" {
  description = "Number of nodes in the graphite-web cluster"
}

variable "carbon_c_relay_node_count" {
  description = "Number of nodes in the carbon-c-relay cluster"
}

variable "team_name" {
  description = "Name of the team owning this infrastructure"
}

variable "security_groups" {
  description = "Security groups necessary for this infrastructure"
}

variable "vpc_id" {
  type        = string
  description = "The VPC to deploy this stack to"
}

variable "pagerduty_url" {
  description = "Pagerduty integration url"
}

variable "vpce_allowed_principals" {
  description = "The list of trusted accounts for the VPCe."
  default     = []
}

variable "owner" {
  type        = string
  description = "The email address of the owner of this account"
}
