# Route53 Service Delegation Management for hls.live-video.net

This code manages `hls.live-video.net` and `<pop>.hls.live-video.net` delegations and its surrounding IAM infrastructure. In addition, the repo contains the HLS CRUD updater automation tooling that allows IVS/starfruit DNS records to update.

# Usage

<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->


- [Requirements](#requirements)
- [Deployment](#deployment)
- [Development](#development)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->

## Requirements

* [tfenv](https://github.com/tfutils/tfenv#automatic)
* AWS credentials to assume `Admin` roles of [twitch-hls-dns@amazon.com (393787499934)](https://isengard.amazon.com/console-access) account.

## Deployment

Refer the following:

1. [Infrastructure](./src/infra) - manage this account and the primary hls.live-video.net hosted zone.
1. [DNS CRUD Updater](./src/crud_updater) - manages the lambda and deploy infrastructure that updates the respective `hls.live-video.net` DNS records.
1. [POP Route53 Zone delegation](https://git.xarth.tv/video-coreservices/tf-io-dns-pop-delegation) - manages `<pop>.hls.live-video.net` delegation.

## Development

On OS X, the following requirements are available via [homebrew](https://brew.sh/).

* Setup [`pre-commit`](https://pre-commit.com/#install).
* Make sure the following dependencies are installed:
  * [`pre-commit terraform`](https://github.com/antonbabenko/pre-commit-terraform#step-1)
  * [`shellcheck`](https://github.com/koalaman/shellcheck#user-content-installing)

Run `pre-commit install` to install `pre-commit` hook.
