# DNS Updater for hls.live-video.net

This module manages the infra and lambda which performs CRUD operations to hls.live-video.net domain.

Prod updates perform upserts to `twitch-hls-dns@amazon.com (393787499934)` account.

# Usage

<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->


- [Dashboard](#dashboard)
- [Special Note about Staging](#special-note-about-staging)
- [Requirements](#requirements)
- [Deployment](#deployment)
  - [Example run](#example-run)
- [Development](#development)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->

# Dashboard

Refer [w.amazon.com](https://w.amazon.com/bin/view/Twitch/VideoCoreServices/DNS/Dasboard/)

# Special Note about Staging

The `staging` account subscribes the `ddns-verified-machines` topic from `twitch-bs-video-ops-stg` party account, which only gets new updates via manual triggers (i.e. not via DHCP hook). The resulting Route53 changes are also upserted to `sjc05.hls.live-video.net` Route53 hosted zone in the `twitch-bs-video-ops-stg` party account, regardless of pop.

# Requirements

* [tfenv](https://github.com/tfutils/tfenv#automatic)
* AWS credentials to assume `Admin` roles of the respective accounts.
  | Environment | Region     | Account  | isengardcli  |
  |-------------|------------|----------|--------------|
  | staging     | us-west-2  | 522498341573 | `isengardcli creds twitch-vidcs+hls-lv-net-edgeupdate-staging-us-west-2 --role Admin` |
  | prod        | us-east-2  | 873126202975 | `isengardcli creds twitch-vidcs+hls-lv-net-edgeupdate-prod-us-east-2 --role Admin` |
  | prod        | us-west-2  | 398750410825 | `isengardcli creds twitch-vidcs+hls-lv-net-edgeupdate-prod-us-west-2 --role Admin` |

# Deployment

Both infrastructure (AWS components) and lambda code (artifact) is managed by a terraform run.

1. For infrastructure changes, the expected terraform changes are applied immediately when run.
1. For lambda (code changes) deployments, a local S3 artifact is generated during the terraform run, uploads to S3, which triggers a codedeploy pipeline to build the lambda artifact and deploy the changes to lambda.

To apply changes, use `./deploy.sh` to run commands.

```bash
./deploy.sh -e <env> -r <region> <terraform-action>
```

## Example run

```terraform
> ./deploy.sh -e prod -r us-east-2 plan
Initializing modules...

Initializing the backend...

Successfully configured the backend "s3"! Terraform will automatically
use this backend unless the backend configuration changes.

Initializing provider plugins...
- Reusing previous version of hashicorp/aws from the dependency lock file
- Reusing previous version of hashicorp/local from the dependency lock file
- Reusing previous version of hashicorp/random from the dependency lock file
- Reusing previous version of hashicorp/archive from the dependency lock file
- Using previously-installed hashicorp/aws v3.55.0
- Using previously-installed hashicorp/local v2.1.0
- Using previously-installed hashicorp/random v3.1.0
- Using previously-installed hashicorp/archive v2.2.0

Terraform has been successfully initialized!

You may now begin working with Terraform. Try running "terraform plan" to see
any changes that are required for your infrastructure. All Terraform commands
should now work.

If you ever set or change modules or backend configuration for Terraform,
rerun this command to reinitialize your working directory. If you forget, other
commands will detect it and remind you to do so if necessary.
module.dns_sqs_lambda_stack.random_uuid.lambda_src_hash: Refreshing state... [id=7a42b893-2d61-c36b-83fa-fb7c4eecfc50]
module.lambda_deploy_stack.aws_iam_role.service_codebuild_role: Refreshing state... [id=hls-lv-net-dns-updater-codebuild-service-role]
module.cloudwatch_wiki.aws_cloudformation_stack.cross_account_cloudwatch_configuration: Refreshing state... [id=arn:aws:cloudformation:us-east-2:873126202975:stack/CloudWatch-CrossAccountSharingRole/f6dfb690-102a-11ec-adc2-06009891ef2c]
module.lambda_deploy_stack.aws_iam_role.service_codedeploy_role: Refreshing state... [id=hls-lv-net-dns-updater-codedeploy-service-role]
module.lambda_deploy_stack.aws_iam_role.service_codepipeline_role: Refreshing state... [id=hls-lv-net-dns-updater-codepipeline-service-role]
module.lambda_deploy_stack.aws_iam_policy.service_codepipeline_allow: Refreshing state... [id=arn:aws:iam::873126202975:policy/codepipeline-hls-lv-net-dns-updater-allow]
module.dns_sqs_lambda_stack.aws_iam_role.service_lambda_role: Refreshing state... [id=hls-lv-net-dns-updater-lambda-role]
module.cloudwatch_wiki.aws_cloudformation_stack.cloudwatchdashboard_wiki_configuration: Refreshing state... [id=arn:aws:cloudformation:us-east-2:873126202975:stack/cloudwatch-dashboard-wiki/f6def340-102a-11ec-9167-069a6a024234]
module.dns_sqs_lambda_stack.aws_sqs_queue.service_deadletter: Refreshing state... [id=https://sqs.us-east-2.amazonaws.com/873126202975/hls-lv-net-dns-updater-deadletter]
module.dns_sqs_lambda_stack.aws_s3_bucket.service_codesource_bucket: Refreshing state... [id=hls-lv-net-dns-updater-codesource-prod-us-east-2]
module.dns_sqs_lambda_stack.aws_sns_topic.cw_alarm_topic: Refreshing state... [id=arn:aws:sns:us-east-2:873126202975:hls-lv-net-dns-updater-alarm-topic]
module.lambda_deploy_stack.aws_codedeploy_app.service_codedeploy_app: Refreshing state... [id=47b81df6-9e29-482e-8b86-23dddab703d6:hls-lv-net-dns-updater-deploy]
module.lambda_deploy_stack.aws_s3_bucket.service_codepipeline_bucket: Refreshing state... [id=hls-lv-net-dns-updater-codepipeline-bucket-prod-us-east-2]
module.lambda_deploy_stack.aws_s3_bucket.service_release_bucket: Refreshing state... [id=hls-lv-net-dns-updater-release-bucket-prod-us-east-2]
module.slack_chatbot.aws_iam_role.chatbot_role: Refreshing state... [id=codepipeline-chatbot-role]
module.dns_sqs_lambda_stack.aws_sqs_queue.service_queue: Refreshing state... [id=https://sqs.us-east-2.amazonaws.com/873126202975/hls-lv-net-dns-updater-queue]
module.lambda_deploy_stack.aws_iam_role_policy_attachment.service_codepipeline_add_policy_attachment: Refreshing state... [id=hls-lv-net-dns-updater-codepipeline-service-role-20210902211518580700000004]
module.dns_sqs_lambda_stack.aws_lambda_function.service_dns_lambda: Refreshing state... [id=hls-lv-net-dns-updater_lambda]
module.lambda_deploy_stack.aws_iam_role_policy_attachment.service_codedeploy_role_policy_attach: Refreshing state... [id=hls-lv-net-dns-updater-codedeploy-service-role-20210902211516276000000003]
module.dns_sqs_lambda_stack.aws_cloudwatch_metric_alarm.deadletter_alarm: Refreshing state... [id=us-east-2-production hls-lv-net-dns-updater SQS deadletter queue has message(s)]
module.dns_sqs_lambda_stack.aws_sns_topic_subscription.cw_alarm_subscription: Refreshing state... [id=arn:aws:sns:us-east-2:873126202975:hls-lv-net-dns-updater-alarm-topic:d92b9d9f-a47c-4785-a25c-3963ba79f6d2]
module.lambda_deploy_stack.aws_codedeploy_deployment_group.service_codedeploy_group: Refreshing state... [id=d6b88e6c-70a2-4c29-a2c1-01e8d2fe8398]
module.dns_sqs_lambda_stack.aws_iam_policy.service_lambda_policy: Refreshing state... [id=arn:aws:iam::873126202975:policy/hls-lv-net-dns-updater-perms]
module.dns_sqs_lambda_stack.aws_sns_topic_subscription.user_updates_sqs_target: Refreshing state... [id=arn:aws:sns:us-east-2:625436545767:ddns-verified-machines:e9b2b72b-53b5-4232-8a84-6e8981d57d59]
module.dns_sqs_lambda_stack.aws_sqs_queue_policy.allow_sns_to_send: Refreshing state... [id=https://sqs.us-east-2.amazonaws.com/873126202975/hls-lv-net-dns-updater-queue]
module.dns_sqs_lambda_stack.aws_lambda_alias.service_prod_alias: Refreshing state... [id=arn:aws:lambda:us-east-2:873126202975:function:hls-lv-net-dns-updater_lambda:PROD]
module.dns_sqs_lambda_stack.aws_iam_role_policy_attachment.service_lambda_policy_attachment: Refreshing state... [id=hls-lv-net-dns-updater-lambda-role-20210902211520936400000007]
module.dns_sqs_lambda_stack.aws_lambda_event_source_mapping.sqs_to_service: Refreshing state... [id=3d64252a-99d3-4a2d-8a80-1aab2534045d]
module.dns_sqs_lambda_stack.aws_s3_bucket_object.lambda_zip_to_codesource: Refreshing state... [id=main/SourceArtifact.zip]
module.lambda_deploy_stack.aws_codebuild_project.service_codebuild_project: Refreshing state... [id=arn:aws:codebuild:us-east-2:873126202975:project/hls-lv-net-dns-updater-build]
module.lambda_deploy_stack.aws_iam_policy.service_codedeploy_allow: Refreshing state... [id=arn:aws:iam::873126202975:policy/codedeploy-hls-lv-net-dns-updater-allow]
module.lambda_deploy_stack.aws_iam_policy.service_codebuild_policy: Refreshing state... [id=arn:aws:iam::873126202975:policy/codebuild-hls-lv-net-dns-updater-service-policy]
module.lambda_deploy_stack.aws_codepipeline.service_codepipeline: Refreshing state... [id=hls-lv-net-dns-updater-prod-pipeline]
module.lambda_deploy_stack.aws_iam_role_policy_attachment.service_codebuild_policy_attachment: Refreshing state... [id=hls-lv-net-dns-updater-codebuild-service-role-20210902211520830400000006]
module.lambda_deploy_stack.aws_iam_role_policy_attachment.service_codedeploy_role_extra_policy_attach: Refreshing state... [id=hls-lv-net-dns-updater-codedeploy-service-role-20210902211520739000000005]
module.slack_sns.aws_sns_topic.pipeline_updates: Refreshing state... [id=arn:aws:sns:us-east-2:873126202975:hls-lv-net-dns-updater-prod-pipeline-slack-chatbot]
module.slack_sns.aws_codestarnotifications_notification_rule.pipeline_updates: Refreshing state... [id=arn:aws:codestar-notifications:us-east-2:873126202975:notificationrule/11cadbfa080fca3964979d7400ffbb43f3b97751]
module.slack_chatbot.aws_cloudformation_stack.slack_chatbot_configuration: Refreshing state... [id=arn:aws:cloudformation:us-east-2:873126202975:stack/codepipeline-slack-chatbot-notification/eb5e59d0-0c32-11ec-910f-02201aaf7cd2]
module.slack_sns.aws_sns_topic_policy.default: Refreshing state... [id=arn:aws:sns:us-east-2:873126202975:hls-lv-net-dns-updater-prod-pipeline-slack-chatbot]

No changes. Your infrastructure matches the configuration.

Terraform has compared your real infrastructure against your configuration and found no differences, so no changes are needed.
Releasing state lock. This may take a few moments...
```

# Development

On OS X, the following requirements are available via [homebrew](https://brew.sh/).

* Setup [`pre-commit`](https://pre-commit.com/#install).
* Make sure the following dependencies are installed:
  * [`pre-commit terraform`](https://github.com/antonbabenko/pre-commit-terraform#step-1)
  * [`shellcheck`](https://github.com/koalaman/shellcheck#user-content-installing)

Run `pre-commit install` to install `pre-commit` hook.
