# Manage _Infra_ and Primary HLS hosted Zone

## Usage

<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->


- [Requirements](#requirements)
- [Deployment](#deployment)
  - [Example Output](#example-output)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->

## Requirements

1. AWS credentials to assume `Admin` role of [twitch-hls-dns@amazon.com (393787499934)](https://isengard.amazon.com/console-access) account.

## Deployment

Standard terraform arguments. E.g. `plan|apply|...`. E.g.

1. `./deploy.sh plan`
1. `./deploy.sh apply`

### Example Output

```bash
./deploy.sh plan

Initializing modules...

Initializing the backend...

Successfully configured the backend "s3"! Terraform will automatically
use this backend unless the backend configuration changes.

Initializing provider plugins...

Terraform has been successfully initialized!

You may now begin working with Terraform. Try running "terraform plan" to see
any changes that are required for your infrastructure. All Terraform commands
should now work.

If you ever set or change modules or backend configuration for Terraform,
rerun this command to reinitialize your working directory. If you forget, other
commands will detect it and remind you to do so if necessary.
Refreshing Terraform state in-memory prior to plan...
The refreshed state will be used to calculate this plan, but will not be
persisted to local or remote state storage.

data.aws_caller_identity.current: Refreshing state...
module.primary.module.iam.data.aws_iam_policy.route53_read_only_access: Refreshing state...
module.primary.data.aws_caller_identity.account: Refreshing state...
module.primary.module.iam.data.aws_iam_policy_document.lvs_dns_sts: Refreshing state...
module.primary.module.zone.aws_route53_zone.service: Refreshing state... [id=Z1GWR9CZ1GXJEY]
module.primary.module.iam.aws_iam_role.lvs_dns_delegation: Refreshing state... [id=lvs-dns-delegation]
module.primary.module.iam.aws_iam_role_policy_attachment.readonly: Refreshing state... [id=lvs-dns-delegation-20200221231008271500000002]

------------------------------------------------------------------------

No changes. Infrastructure is up-to-date.

This means that Terraform did not detect any differences between your
configuration and real physical resources that exist. As a result, no
actions need to be performed.
```
