terraform {
  required_version = "=0.12.21"

  backend "s3" {
    region         = "us-west-2"
    dynamodb_table = "terraform_locks"
    bucket         = "hls-live-video-net-dns-tf-state"
    key            = "infra.tfstate"
  }
}

# us-east-1 for log group
provider "aws" {
  region  = "us-east-1"
  version = "~> 2.49"
}

provider "null" {
  version = "~> 2.1"
}

locals {
  r53_query_log_group = "/aws/route53/hls-live-video-net-query-logs"
}

# Only allow Admin to execute TF changes
data "aws_caller_identity" "current" {}

resource "null_resource" "validate_role" {
  count = element(split("/", data.aws_caller_identity.current.arn), 1) == "Admin" ? 0 : "Please use Admin role to perform operations"
}

# one log-group per subdomain so insights can be selected once per subdomain account
resource "aws_cloudwatch_log_group" "hls_dns_log_group" {
  name              = local.r53_query_log_group
  retention_in_days = 90
}
