variable "service" {
  description = "The name of the service"
  default     = "hls"
}

module "primary" {
  source  = "git@git.xarth.tv:video-coreservices/tf-mod-live-video-dns-delegation.git//primary?ref=v1.0.4"
  service = "hls"
  domain  = "live-video.net"

  comment = "${title(var.service)} Service Primary DNS"

  tags = {
    Owner       = "video-coreservices@twitch.tv"
    Environment = "prod"
    Service     = "hls-dns"
    Src         = "video-coreservices/tf-io-hls-dns"
  }
}

output "primary" {
  value = module.primary
}
