#!/usr/bin/env python3

# Requires AWS readonly access to Route53 twitch-hls-dns@amazon.com (393787499934) account

import boto3
import pydig

client = boto3.client('route53')

records = client.list_resource_record_sets(
    HostedZoneId='Z1GWR9CZ1GXJEY',
)

for r in records.get('ResourceRecordSets'):
    if not r.get('Type') == 'NS':
        continue

    subdomain = r.get('Name')
    delegation = [ns.get('Value').rstrip('.') for ns in r.get('ResourceRecords')]

    # Remove trailing .
    resolver = pydig.Resolver(nameservers=delegation)
    ns_dig = [s.rstrip('.') for s in resolver.query(subdomain, 'NS')]

    print("Validating {}".format(subdomain))
    if set(delegation) == set(ns_dig):
        print("Delegation and internet matches")
    else:
        print("DO NOT MATCH, dig: {}, delegation: {}".format(ns_dig, delegation))
