# DNS Updater submodule

This module manages the infra and lambda which performs CRUD operations to hls.ttvnw.net domain. More info can be found in the [wiki](https://wiki.xarth.tv/display/VID/DNS+Validator+and+DDNS+Updates).

Prod updates perform upserts to `twitch-vidcs+hls-ttvnw-net-dns@amazon.com` (707969931081) account.

**Note**: The infra is setup to upsert the following domains. Note that the `<pop>.hls.ttvnw.net` domains are not used by `video-edge` machines, and is only used by `video-weaver-lb` (i.e. `video-weaver.<pop>.hls.ttvnw.net`).

| Environment | Domain Updated                 |
|-------------|--------------------------------|
| staging     | `staging.abs.hls.ttvnw.net`    |
|             | `staging.no-abs.hls.ttvnw.net` |
| prod        | `<pop>.abs.hls.ttvnw.net`      |
|             | `<pop>.no-abs.hls.ttvnw.net`   |

<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->


- [Dashboard and Notifications](#dashboard-and-notifications)
- [Requirements](#requirements)
- [Deployment](#deployment)
  - [Example run](#example-run)
- [Development](#development)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->

# Dashboard and Notifications

* Dashboard: [Cloudwatch Dashboards](https://w.amazon.com/bin/view/Twitch/VideoCoreServices/DNS/Dasboard/)
* Slack Pipeline Deploy notifications: [#vidcs-ddns-deploy](https://twitch.slack.com/archives/C02BTS4HLAH)

# Requirements

* [tfenv](https://github.com/tfutils/tfenv#automatic)
* AWS credentials to assume `Admin` roles of the respective accounts.
  | Environment | Region     | Account  | isengardcli  |
  |-------------|------------|----------|--------------|
  | staging     | us-west-2  | 007812478044 | `isengardcli creds twitch-vidcs+hls-ttvnw-net-edgeupdate-staging-usw2 --role Admin` |
  | prod        | us-east-2  | 599087406594 | `isengardcli creds twitch-vidcs+hls-ttvnw-net-edgeupdate-prod-us-east-2 --role Admin` |
  | prod        | us-west-2  | 102890704200 | `isengardcli creds twitch-vidcs+hls-ttvnw-net-edgeupdate-prod-us-west-2 --role Admin` |

# Deployment

Both infrastructure (AWS components) and lambda code (artifact) is managed by a terraform run.

1. For infrastructure changes, the expected terraform changes are applied immediately when run.
1. For lambda (code changes) deployments, a local S3 artifact is generated during the terraform run, uploads to S3, which triggers a codedeploy pipeline to build the lambda artifact and deploy the changes to lambda.

To apply changes, use `./deploy.sh` to run commands.

```bash
./deploy.sh -e <env> -r <region> <terraform-action>
```

## Example run

```terraform
> ./deploy.sh -e prod -r us-east-2 plan
Initializing modules...

Initializing the backend...

Successfully configured the backend "s3"! Terraform will automatically
use this backend unless the backend configuration changes.

Initializing provider plugins...
- Reusing previous version of hashicorp/aws from the dependency lock file
- Reusing previous version of hashicorp/local from the dependency lock file
- Reusing previous version of hashicorp/random from the dependency lock file
- Reusing previous version of hashicorp/archive from the dependency lock file
- Using previously-installed hashicorp/aws v3.60.0
- Using previously-installed hashicorp/local v2.1.0
- Using previously-installed hashicorp/random v3.1.0
- Using previously-installed hashicorp/archive v2.2.0

Terraform has been successfully initialized!

You may now begin working with Terraform. Try running "terraform plan" to see
any changes that are required for your infrastructure. All Terraform commands
should now work.

If you ever set or change modules or backend configuration for Terraform,
rerun this command to reinitialize your working directory. If you forget, other
commands will detect it and remind you to do so if necessary.
module.dns_sqs_lambda_stack.random_uuid.lambda_src_hash: Refreshing state... [id=c788190f-2142-2a33-5524-e50b241cbd9a]
module.lambda_deploy_stack.aws_s3_bucket.service_codepipeline_bucket: Refreshing state... [id=hls-ttvnw-net-dns-updater-codepipeline-bucket-prod-us-east-2]
module.cloudwatch_wiki.aws_cloudformation_stack.cross_account_cloudwatch_configuration: Refreshing state... [id=arn:aws:cloudformation:us-east-2:599087406594:stack/CloudWatch-CrossAccountSharingRole/0fe0ce20-1fdc-11ec-9f54-0283dea58ef6]
module.dns_sqs_lambda_stack.aws_s3_bucket.service_codesource_bucket: Refreshing state... [id=hls-ttvnw-net-dns-updater-codesource-prod-us-east-2]
module.lambda_deploy_stack.aws_iam_policy.service_codepipeline_allow: Refreshing state... [id=arn:aws:iam::599087406594:policy/codepipeline-hls-ttvnw-net-dns-updater-allow]
module.lambda_deploy_stack.aws_iam_role.service_codedeploy_role: Refreshing state... [id=hls-ttvnw-net-dns-updater-codedeploy-service-role]
module.lambda_deploy_stack.aws_iam_role.service_codepipeline_role: Refreshing state... [id=hls-ttvnw-net-dns-updater-codepipeline-service-role]
module.dns_sqs_lambda_stack.aws_sqs_queue.service_deadletter: Refreshing state... [id=https://sqs.us-east-2.amazonaws.com/599087406594/hls-ttvnw-net-dns-updater-deadletter]
module.dns_sqs_lambda_stack.aws_sns_topic.cw_alarm_topic: Refreshing state... [id=arn:aws:sns:us-east-2:599087406594:hls-ttvnw-net-dns-updater-alarm-topic]
module.lambda_deploy_stack.aws_iam_role.service_codebuild_role: Refreshing state... [id=hls-ttvnw-net-dns-updater-codebuild-service-role]
module.lambda_deploy_stack.aws_codedeploy_app.service_codedeploy_app: Refreshing state... [id=d79bb42b-62ea-4683-a382-3cd292aac77e:hls-ttvnw-net-dns-updater-deploy]
module.dns_sqs_lambda_stack.aws_iam_role.service_lambda_role: Refreshing state... [id=hls-ttvnw-net-dns-updater-lambda-role]
module.lambda_deploy_stack.aws_s3_bucket.service_release_bucket: Refreshing state... [id=hls-ttvnw-net-dns-updater-release-bucket-prod-us-east-2]
module.cloudwatch_wiki.aws_cloudformation_stack.cloudwatchdashboard_wiki_configuration: Refreshing state... [id=arn:aws:cloudformation:us-east-2:599087406594:stack/cloudwatch-dashboard-wiki/0fe1df90-1fdc-11ec-9d62-0a07947216d6]
module.slack_chatbot.aws_iam_role.chatbot_role: Refreshing state... [id=codepipeline-chatbot-role]
module.dns_sqs_lambda_stack.aws_sns_topic_subscription.cw_alarm_subscription: Refreshing state... [id=arn:aws:sns:us-east-2:599087406594:hls-ttvnw-net-dns-updater-alarm-topic:ff9227ce-9931-4490-a4b1-372033f456a0]
module.dns_sqs_lambda_stack.aws_sqs_queue.service_queue: Refreshing state... [id=https://sqs.us-east-2.amazonaws.com/599087406594/hls-ttvnw-net-dns-updater-queue]
module.dns_sqs_lambda_stack.aws_cloudwatch_metric_alarm.deadletter_alarm: Refreshing state... [id=us-east-2-production hls-ttvnw-net-dns-updater SQS deadletter queue has message(s)]
module.lambda_deploy_stack.aws_iam_role_policy_attachment.service_codedeploy_role_policy_attach: Refreshing state... [id=hls-ttvnw-net-dns-updater-codedeploy-service-role-20210927214418563000000004]
module.lambda_deploy_stack.aws_iam_role_policy_attachment.service_codepipeline_add_policy_attachment: Refreshing state... [id=hls-ttvnw-net-dns-updater-codepipeline-service-role-20210927214418519200000003]
module.lambda_deploy_stack.aws_codedeploy_deployment_group.service_codedeploy_group: Refreshing state... [id=eb19ef10-d8f6-4366-bbf4-b48e52edfcdb]
module.dns_sqs_lambda_stack.aws_lambda_function.service_dns_lambda: Refreshing state... [id=hls-ttvnw-net-dns-updater_lambda]
module.dns_sqs_lambda_stack.aws_iam_policy.service_lambda_policy: Refreshing state... [id=arn:aws:iam::599087406594:policy/hls-ttvnw-net-dns-updater-perms]
module.dns_sqs_lambda_stack.aws_sns_topic_subscription.user_updates_sqs_target: Refreshing state... [id=arn:aws:sns:us-east-2:625436545767:ddns-verified-machines:d41d4c7d-fede-4f95-9343-7bcd04ecc696]
module.dns_sqs_lambda_stack.aws_iam_role_policy_attachment.service_lambda_policy_attachment: Refreshing state... [id=hls-ttvnw-net-dns-updater-lambda-role-20210927214421662600000005]
module.dns_sqs_lambda_stack.aws_sqs_queue_policy.allow_sns_to_send: Refreshing state... [id=https://sqs.us-east-2.amazonaws.com/599087406594/hls-ttvnw-net-dns-updater-queue]
module.dns_sqs_lambda_stack.aws_lambda_alias.service_prod_alias: Refreshing state... [id=arn:aws:lambda:us-east-2:599087406594:function:hls-ttvnw-net-dns-updater_lambda:PROD]
module.dns_sqs_lambda_stack.aws_lambda_event_source_mapping.sqs_to_service: Refreshing state... [id=b9e96982-df4c-49ae-a8d1-b2ac59865eab]
module.dns_sqs_lambda_stack.aws_s3_bucket_object.lambda_zip_to_codesource: Refreshing state... [id=main/SourceArtifact.zip]
module.lambda_deploy_stack.aws_iam_policy.service_codebuild_policy: Refreshing state... [id=arn:aws:iam::599087406594:policy/codebuild-hls-ttvnw-net-dns-updater-service-policy]
module.lambda_deploy_stack.aws_iam_policy.service_codedeploy_allow: Refreshing state... [id=arn:aws:iam::599087406594:policy/codedeploy-hls-ttvnw-net-dns-updater-allow]
module.lambda_deploy_stack.aws_codebuild_project.service_codebuild_project: Refreshing state... [id=arn:aws:codebuild:us-east-2:599087406594:project/hls-ttvnw-net-dns-updater-build]
module.lambda_deploy_stack.aws_codepipeline.service_codepipeline: Refreshing state... [id=hls-ttvnw-net-dns-updater-prod-pipeline]
module.lambda_deploy_stack.aws_iam_role_policy_attachment.service_codedeploy_role_extra_policy_attach: Refreshing state... [id=hls-ttvnw-net-dns-updater-codedeploy-service-role-20210927214422980300000006]
module.lambda_deploy_stack.aws_iam_role_policy_attachment.service_codebuild_policy_attachment: Refreshing state... [id=hls-ttvnw-net-dns-updater-codebuild-service-role-20210927214423058100000007]
module.slack_sns.aws_sns_topic.pipeline_updates: Refreshing state... [id=arn:aws:sns:us-east-2:599087406594:hls-ttvnw-net-dns-updater-prod-pipeline-slack-chatbot]
module.slack_sns.aws_codestarnotifications_notification_rule.pipeline_updates: Refreshing state... [id=arn:aws:codestar-notifications:us-east-2:599087406594:notificationrule/831f8db221571ef80770a7fed3f849d7b4636917]
module.slack_chatbot.aws_cloudformation_stack.slack_chatbot_configuration: Refreshing state... [id=arn:aws:cloudformation:us-east-2:599087406594:stack/codepipeline-slack-chatbot-notification/1beff6a0-1fdc-11ec-9e1e-0aa9a9fbbf78]
module.slack_sns.aws_sns_topic_policy.default: Refreshing state... [id=arn:aws:sns:us-east-2:599087406594:hls-ttvnw-net-dns-updater-prod-pipeline-slack-chatbot]

No changes. Your infrastructure matches the configuration.

Terraform has compared your real infrastructure against your configuration and found no differences, so no changes are needed.
Releasing state lock. This may take a few moments...
```

# Development

On OS X, the following requirements are available via [homebrew](https://brew.sh/).

* Setup [`pre-commit`](https://pre-commit.com/#install).
* Make sure the following dependencies are installed:
  * [`pre-commit terraform`](https://github.com/antonbabenko/pre-commit-terraform#step-1)
  * [`shellcheck`](https://github.com/koalaman/shellcheck#user-content-installing)

Run `pre-commit install` to install `pre-commit` hook.
