terraform {
  required_version = "=1.0.7"
  backend "s3" {}
}

provider "aws" {
  region = var.region
}

locals {
  repo_src          = "video-coreservices/tf-io-hls-ttvnw-net-dns/src/crud_updater"
  codesource_bucket = "${var.service_id}-codesource-${var.env}-${var.region}"
}

module "dns_sqs_lambda_stack" {
  source               = "git@git.xarth.tv:video-coreservices/tf-mod-dns-sqs-lambda.git?ref=v2.1.0"
  env                  = var.env
  region               = var.region
  repo_src             = local.repo_src
  service_id           = var.service_id
  codesource_bucket_id = local.codesource_bucket
  input_sns_arn        = var.input_sns_arn
  target_dns_domains   = var.target_dns_domains
  pop_subdomain        = var.pop_subdomain

  crud_allowlist = var.crud_allowlist

  dns_updater_role = var.dns_updater_role
  pd_url           = var.pd_url
}

module "lambda_deploy_stack" {
  source               = "git@git.xarth.tv:video-coreservices/tf-mod-lambda-pipeline.git?ref=v1.1.0"
  env                  = var.env
  region               = var.region
  repo_src             = local.repo_src
  service_id           = var.service_id
  lambda_function_name = module.dns_sqs_lambda_stack.service_lambda_arn
  codesource_bucket_id = local.codesource_bucket
}

# Slack notifications on lambda deploys
module "slack_sns" {
  source             = "git@git.xarth.tv:video/chatbot-terraform.git//modules/sns?ref=v1.0.0"
  codepipeline_arn   = module.lambda_deploy_stack.codepipeline_arn
  codepipeline_name  = module.lambda_deploy_stack.codepipeline_name
  configuration_name = "${module.lambda_deploy_stack.codepipeline_name}-slack-chatbot"
}

module "slack_chatbot" {
  source           = "git@git.xarth.tv:video/chatbot-terraform.git//modules/chatbot?ref=v1.0.0"
  slack_channel_id = "C02BTS4HLAH" # vidcs-ddns-deploy
  sns_topic_arns = [
    module.slack_sns.chatbot_sns_topic,
  ]
}

# Allow cloudwatch on w.amazon.com
module "cloudwatch_wiki" {
  source = "git@git.xarth.tv:video-coreservices/tf-mod-cloudwatchdashboards-wiki.git?ref=v1.1.2"
  region = var.region
}
