# Required vars
variable "input_sns_arn" {
  description = "The ARN of the SNS topic to receive notifications to trigger the pipeline."
  type        = string
}

# Optional vars
variable "env" {
  description = "Service environment - (prod|staging)."
  type        = string
}

variable "region" {
  description = "The AWS region this service will be deployed."
  type        = string
}

variable "service_id" {
  description = "The name of your application."
  default     = "hls-ttvnw-net-dns-updater"
  type        = string
}

variable "dns_updater_role" {
  description = "The Route53 account IAM role ARN which allows the lambda to perform CRUD operations"
  default     = "arn:aws:iam::707969931081:role/hls-ttvnw-net-dns-updater-lambda-role"
  type        = string
}

variable "target_dns_domains" {
  description = "The 'root' subdomain this DNS pipeline is responsible for updating"
  type        = list(string)

  default = [
    "abs.hls.ttvnw.net",
    "no-abs.hls.ttvnw.net",
  ]
}

variable "pd_url" {
  description = "The pagerduty URL alarms for the stack should send to. Defaults to vidcs business hours only"
  type        = string
  default     = "https://events.pagerduty.com/integration/fb79deea275748acb67a80c0b88c7a7d/enqueue"
}

variable "crud_allowlist" {
  description = "List of machine classes the lambda pipeline supports"
  type        = list(string)

  default = [
    "video-edge",
  ]
}

variable "pop_subdomain" {
  description = "Whether to prepend the target_dns_domain with POP (i.e. .<target_dns_domain>, or only use target_dns_domain"
  default     = true
  type        = bool
}
