# Manage _Infra_ and Primary hls.ttvnw.net hosted Zone

This code manages `hls.ttvnw.net` domain and its surrounding IAM infrastructure.

## Usage

<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->


- [Requirements](#requirements)
- [Deployment](#deployment)
  - [Example Output](#example-output)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->

## Requirements

1. AWS credentials to assume `Admin` role of [twitch-vidcs+hls-ttvnw-net-dns@amazon.com (707969931081)](https://isengard.amazon.com/console-access) account.

   ```bash
   isengardcli assume twitch-vidcs+hls-ttvnw-net-dns@amazon.com --role Admin
   ```

## Deployment

Standard terraform arguments. E.g. `plan|apply|...`. E.g.

1. `./deploy.sh plan`
1. `./deploy.sh apply`

### Example Output

```bash
./deploy.sh plan

Initializing modules...

Initializing the backend...

Successfully configured the backend "s3"! Terraform will automatically
use this backend unless the backend configuration changes.

Initializing provider plugins...
- Reusing previous version of hashicorp/aws from the dependency lock file
- Reusing previous version of hashicorp/null from the dependency lock file
- Using previously-installed hashicorp/aws v3.46.0
- Using previously-installed hashicorp/null v3.1.0

Terraform has been successfully initialized!

You may now begin working with Terraform. Try running "terraform plan" to see
any changes that are required for your infrastructure. All Terraform commands
should now work.

If you ever set or change modules or backend configuration for Terraform,
rerun this command to reinitialize your working directory. If you forget, other
commands will detect it and remind you to do so if necessary.
aws_cloudwatch_log_group.hls_dns_log_group: Refreshing state... [id=/aws/route53/hls-ttvnw-net-query-logs]
module.primary.module.zone.aws_route53_zone.service: Refreshing state... [id=Z08378525UZ9H4ASZ101]
aws_iam_policy.spade_uri_rotation_prod: Refreshing state... [id=arn:aws:iam::707969931081:policy/spade-uri-rotation-prod]
aws_iam_role_policy_attachment.pop_dns_readonly_attachment: Refreshing state... [id=twitch-pop-hls-ttvnw-net-dns-20210630055311639700000002]
aws_cloudwatch_log_resource_policy.r53_query_logging_policy: Refreshing state... [id=route53-query-logging-policy]
aws_iam_role.spade_uri_rotation_prod: Refreshing state... [id=spade-uri-rotation-prod]
module.pop_delegation.aws_iam_role.control: Refreshing state... [id=dns-pop-delegation-control]
module.primary.module.iam.aws_iam_role.lvs_dns_delegation: Refreshing state... [id=lvs-dns-delegation]
aws_iam_policy.pop_dns_crud_policy: Refreshing state... [id=arn:aws:iam::707969931081:policy/twitch-pop-hls-ttvnw-net-dns-route53]
aws_iam_role_policy_attachment.spade_uri_rotation_prod_attachment: Refreshing state... [id=spade-uri-rotation-prod-20210806215825045800000001]
aws_iam_role_policy_attachment.spade_uri_rotation_prod_readonly_attachment: Refreshing state... [id=spade-uri-rotation-prod-20210806215825067000000002]
module.pop_delegation.aws_iam_role_policy.deny_delete: Refreshing state... [id=dns-pop-delegation-control:terraform-20210921180923168500000001]
module.pop_delegation.aws_iam_role_policy_attachment.route53_fullaccess: Refreshing state... [id=dns-pop-delegation-control-20210921180923552900000002]
aws_iam_role_policy_attachment.pop_dns_crud_attachment: Refreshing state... [id=twitch-pop-hls-ttvnw-net-dns-20210806215910250600000001]
module.primary.module.iam.aws_iam_role_policy_attachment.readonly: Refreshing state... [id=lvs-dns-delegation-20210630045736792500000001]

No changes. Your infrastructure matches the configuration.
```
