terraform {
  required_version = "=1.0.7"

  backend "s3" {
    region         = "us-west-2"
    dynamodb_table = "terraform_locks"
    bucket         = "hls-ttvnw-net-dns-us-west-2-prod-tf-state"
    key            = "infra.tfstate"
  }

  required_providers {
    aws = {
      version = "~> 3.46"
    }

    null = {
      version = "~> 3.1"
    }
  }
}

# us-east-1 for log group
provider "aws" {
  region = "us-east-1"

  default_tags {
    tags = {
      Owner       = "video-coreservices@twitch.tv"
      Environment = "prod"
      Service     = "hls.ttvnw.net-dns"
      Src         = "video-coreservices/tf-io-hls-ttvnw-net-dns"
    }
  }
}

provider "null" {}

# Only allow Admin to execute TF changes
data "aws_caller_identity" "current" {}

resource "null_resource" "validate_role" {
  count = element(split("/", data.aws_caller_identity.current.arn), 1) == "Admin" ? 0 : "Please use Admin role to perform operations"
}
