locals {
  r53_query_log_group = "/aws/route53/hls-ttvnw-net-query-logs"
}

# one log-group per subdomain so insights can be selected once per subdomain account
resource "aws_cloudwatch_log_group" "hls_dns_log_group" {
  name              = local.r53_query_log_group
  retention_in_days = 90
}

###########################################################
# Permit route53 service to log to any /aws/route53 log group
###########################################################

# cloudWatch log resource policy to allow Route53 to write logs
# to any log group under /aws/route53/hls-ttvnw-net-query-logs
data "aws_iam_policy_document" "r53_query_logging_policy" {
  statement {
    actions = [
      "logs:CreateLogStream",
      "logs:PutLogEvents",
    ]
    resources = [
      "arn:aws:logs:*:*:log-group:${local.r53_query_log_group}*",
    ]

    principals {
      identifiers = ["route53.amazonaws.com"]
      type        = "Service"
    }
  }
}

resource "aws_cloudwatch_log_resource_policy" "r53_query_logging_policy" {
  policy_document = data.aws_iam_policy_document.r53_query_logging_policy.json
  policy_name     = "route53-query-logging-policy"
}
