module "icp" {
  source = "git::git+ssh://git@git.xarth.tv/video-coreservices/tf-mod-icp"
  account = var.account
  region = var.region
  owner = var.owner
  service-acct-icp-leaf-role = var.service-acct-icp-leaf-role
  service-name = var.service-name
  service-endpoint = var.service-endpoint
  root-maintenance-assume-isengardid = var.root-maintenance-assume-isengardid
  intermediate-maintenance-assume-isengardid = var.intermediate-maintenance-assume-isengardid
  service-leaf-issuance-assume-isengardid = var.service-leaf-issuance-assume-isengardid
}

terraform {
  backend "s3" {
    bucket     = "twitch-vidcs-dev-tfstate"
    key        = "tf-io-icp-example/terraform.tfstate"
    dynamodb_table = "terraform_locks"
    region = "us-west-2"
  }
  required_version = ">= 1.0.1"
}

