variable "account" {
  description = "the human readable account name (used for tagging)"
  type        = string
  default     = "vidcs-dev"
}

variable "region" {
  description = "The region you're building this PCA instance in"
  type        = string
  default     = "us-west-2"
}

variable "service-acct-icp-leaf-role" {
  description = "ARN of the service account role fetching leaf certs"
  type        = string
}

variable "owner" {
  description = "the human readable account owner (used for tagging)"
  type        = string
  default     = "video core services"
}

variable "root-maintenance-assume-isengardid" {
  description = "the sts:ExternalId allowed to assume the icp-root-maintenance role"
  type        = string
}

variable "intermediate-maintenance-assume-isengardid" {
  description = "the sts:ExternalId allowed to assume the icp-intermediate-maintenance role"
  type        = string
}

variable "service-leaf-issuance-assume-isengardid" {
  description = "the sts:ExternalId allowed to assume the icp-service-leaf-issuance role"
  type        = string
}

variable "root-ca-generation" {
  description = "the version of root CA certificate"
  type        = number
  default     = 1
}

variable "intermediate-ca-generation" {
  description = "the version of intermediate CA certificate"
  type        = number
  default     = 1
}

variable "service-name" {
  description = "a single word service name, used for resoure naming"
  type        = string
  default     = "foobarbaz"
}

variable "service-endpoint" {
  description = "the dns name of your service endpoint, used as certificate CN"
  type        = string
  default     = "staging.us-west-2.foobarbaz.live-video.net"
}

