// attach this policy to the role your service or service sidecar runs as.

variable "service-leaf-arn" {
  description = "the service-leaf-arn output from the ICP account tf in this partition"
}

resource "aws_iam_policy" "icp-leaf" {
  description = "Service leaf assume-role access"
  policy      = data.aws_iam_policy_document.icp-leaf.json
}

data "aws_iam_policy_document" "icp-leaf" {
  statement {
    effect = "Allow"
    actions = ["sts:AssumeRole"]
    resources = [ var.service-leaf-arn ]
  }
}
