terraform {
  backend "s3" {
    region     = "us-west-2"
    bucket     = "dhollim-tf-state"
    key        = "tf-io-icp-example/terraform.tfstate"
    dynamodb_table = "terraform_locks"
  }
  required_version = ">= 1.0.1"
}

resource "aws_iam_role" "icp-leaf" {
  name               = "icp-leaf"
  max_session_duration = 43200
  assume_role_policy = data.aws_iam_policy_document.icp-leaf-assume.json
}

resource "aws_iam_role_policy_attachment" "icp-leaf" {
  role       = aws_iam_role.icp-leaf.name
  policy_arn = aws_iam_policy.icp-leaf.arn
}

data "aws_iam_policy_document" "icp-leaf-assume" {
  statement {
    effect = "Allow"
    principals {
      identifiers = ["arn:aws:iam::727820809195:root"]
      type        = "AWS"
    }
    actions = ["sts:AssumeRole"]
    condition {
      test     = "StringEquals"
      variable = "sts:ExternalId"
      values   = [ "IsengardExternalId6mQiHeYZtxwF" ]
    }
  }
}

data "aws_iam_policy_document" "service-intermediate-assume" {
  statement {
    effect = "Allow"
    principals {
      identifiers = ["arn:aws:iam::727820809195:root"]
      type        = "AWS"
    }
    actions = ["sts:AssumeRole"]
    condition {
      test     = "StringEquals"
      variable = "sts:ExternalId"
      values   = [ "IsengardExternalIdUn1zi7ZSVwDx" ]
    }
  }
}

