// This is the role used to fetch intermediate bundles, used to verify calling services.

resource "aws_iam_policy" "service-intermediate" {
  description = "Service intermediate assume-role access"
  policy      = data.aws_iam_policy_document.service-intermediate.json
}

data "aws_iam_policy_document" "service-intermediate" {
  statement {
    effect = "Allow"
    actions = ["sts:AssumeRole"]
    // allowed by org at destination role
    resources = [ "*" ]
  }
}

resource "aws_iam_role" "service-intermediate" {
  name               = "service-intermediate"
  max_session_duration = 43200
  assume_role_policy = data.aws_iam_policy_document.service-intermediate-assume.json
}

resource "aws_iam_role_policy_attachment" "service-intermediate" {
  role       = aws_iam_role.service-intermediate.name
  policy_arn = aws_iam_policy.service-intermediate.arn
}

