# Optional inputs
variable "env" {
  description = "Service environment - (prod|stage)"
  default     = "stage"
}

variable "region" {
  description = "The AWS region this service will be deployed"
  default     = "us-west-2"
}

variable "instance_type" {
  description = "EC2 instance type this service will be running on"
  default     = "t2.small"
}

variable "enable_monitoring" {
  description = "Enable notification on all the checks"
  default     = true
}

# Legacy mappings of environment long names
locals {
  environment_map = {
    prod  = "production"
    stage = "staging"
    dev   = "development"
  }

  environment = local.environment_map[var.env]

  common_tags = {
    Owner       = "video-coreservices@twitch.tv"
    Service     = "infoblox-snmp-collector"
    Environment = var.env
    Source      = "video-coreservices/tf-io-infoblox-snmp-collector"
  }
}
