# tf-io-infoblox Lambda Terraform

This module creates a Lambda in the `twitch-bs-video-ops-aws@amazon.com` account with the IAM policies necessary to read/write to a bucket located in the `twitch-video-coreservices+infoblox-backup@amazon.com` account. The bucket has versioning enabled.

## Deploying

### Create s3 bucket for storing infoblox backups

Assume Account twitch-video-coreservices+infoblox-backup@amazon.com 937337030785
Assume Role Admin

cd into infoblox-backup-bucket . run terraform
```
$ cd infoblox-backup-bucket/
$ bash ./deploy.sh init
$ bash ./deploy.sh plan
$ bash ./deploy.sh apply
```

### Create s3 bucket and dynamodb lock table for storing infoblox-backup-lambda terraform state

Assume Account twitch-bs-video-ops-aws@amazon.com 277437172290
Assume Role Admin

```
$ aws s3 mb s3://infoblox-backup-us-west-2-prod-tf-state --region us-west-2
```
```
$ aws dynamodb create-table --region us-west-2 --table-name infoblox-backup-us-west-2-prod_lock \
  --attribute-definitions AttributeName=LockID,AttributeType=S --key-schema AttributeName=LockID,KeyType=HASH \
  --provisioned-throughput ReadCapacityUnits=1,WriteCapacityUnits=1
```

### Setup Lambda and Cloudwatch Event

Assume Account twitch-bs-video-ops-aws@amazon.com 277437172290
Assume Role Admin

cd into infoblox-backup-lambda . run terraform
```
$ cd infoblox-backup-lambda/
$ bash ./deploy.sh -e prod init
$ bash ./deploy.sh -e prod plan
$ bash ./deploy.sh -e prod apply
```
### Destroying project
terraform destroy in infoblox-backup-lambda will not delete the s3 bucket twitch-infoblox-backup , since its not part of the terraform state for infoblox-backup-lambda
