#!/usr/bin/env bash

set -eo pipefail

usage() {
    echo "Usage: $0 <command> [args]"
    exit 1
}

requirements() {
    command -v tfenv &> /dev/null || ( echo "tfenv required but missing" && usage )
}

tf_init() {
    shift
    terraform init "$@"
}

case "$1" in
    init)
        tf_init "$@"
        ;;
    plan|apply)
        tf_init "$@"
        exec terraform "$@" \
            -var-file="../common/outputs.tf"
        ;;
    *)
        exec terraform "$@"
        ;;
esac
