resource "aws_s3_bucket" "output_bucket" {
  bucket = var.output_bucket
  acl    = "private"

  policy = data.aws_iam_policy_document.bucket_policy.json

  versioning {
    enabled = true
  }

  lifecycle_rule {
    id      = "90 day retention for non-current versions"
    enabled = true

    noncurrent_version_expiration {
        days = 90
    }

    expiration {
        expired_object_delete_marker = true
    }

    abort_incomplete_multipart_upload_days = 7
  }

}

data "aws_iam_policy_document" "bucket_policy" {
  statement {
    sid = "Stmt1592861465153"
    effect = "Allow"

    principals {
      type        = "AWS"
      identifiers = ["${var.trusted_account}"]
    }

    actions = [
      "s3:*",
    ]

    resources = [
      "arn:aws:s3:::${var.output_bucket}"
    ]
  }
}

