resource "aws_cloudwatch_event_rule" "cloudwatch_event_rule" {
  name                = "Infoblox-backup-daily"
  description         = "Runs lambda to do daily backup of infoblox"
  # every day at 08:36 AM
  schedule_expression = "cron(36 8 * * ? *)"
}

resource "aws_cloudwatch_event_target" "cloudwatch_event_target" {
  rule      = aws_cloudwatch_event_rule.cloudwatch_event_rule.name
  target_id = aws_lambda_function.lambda_function.id
  arn       = aws_lambda_function.lambda_function.arn
}

resource "aws_cloudwatch_log_group" "log_group" {
  name              = "/aws/lambda/${local.function_name}"
  retention_in_days = 14
}

resource "aws_cloudwatch_metric_alarm" "error_alarm" {
  alarm_name          = "${local.function_name}-ErrorCount"
  alarm_description   = "Monitors ${local.function_name} for 1 error within 24 hours"
  alarm_actions       = ["${aws_sns_topic.cloudwatch_alarm_topic.arn}"]
  ok_actions          = ["${aws_sns_topic.cloudwatch_alarm_topic.arn}"]
  comparison_operator = "GreaterThanThreshold"
  threshold           = "0"
  evaluation_periods  = "1"
  period              = "86400" # 24 hours
  metric_name         = "Errors"
  namespace           = "AWS/Lambda"
  statistic           = "Sum"
  datapoints_to_alarm = "1"

  dimensions = {
    FunctionName = "${local.function_name}"
  }
}

