resource "null_resource" "lambda_buildstep" {
  triggers = {
    handler      = "${base64sha256(file("lambda_function/backup_lambda.py"))}"
    requirements = "${base64sha256(file("lambda_function/requirements.txt"))}"
    build        = "${base64sha256(file("lambda_function/build.sh"))}"
  }

  provisioner "local-exec" {
    command = "${path.module}/lambda_function/build.sh"
  }
}

resource "aws_lambda_function" "lambda_function" {
  function_name    = local.function_name
  role             = aws_iam_role.role.arn
  handler          = "backup_lambda.lambda_handler"
  timeout          = var.lambda_timeout
  runtime          = var.runtime
  description      = "Backup Infoblox settings from the Grid Master"
  memory_size      = 256
  tags             = local.tags

  vpc_config {
    subnet_ids         = module.variables.private_subnet_ids
    security_group_ids = ["${module.variables.sg_twitch_subnet_id}"]
  }

  environment {
    variables = {
        BACKUP_BUCKET            = var.output_bucket
        INFOBLOX_GRIDMASTER      = var.infoblox_gridmaster
        REGION                   = var.region
    }
  }

  filename         = "${data.archive_file.lambda_function.output_path}"
  source_code_hash = "${data.archive_file.lambda_function.output_base64sha256}"
}

resource "aws_lambda_permission" "lambda_permission" {
  statement_id  = "AllowExecutionFromCloudWatch"
  action        = "lambda:InvokeFunction"
  function_name = local.function_name
  principal     = "events.amazonaws.com"
  source_arn    = aws_cloudwatch_event_rule.cloudwatch_event_rule.arn
}

data "archive_file" "lambda_function" {
  source_dir  = "${path.module}/lambda_function/"
  output_path = "${path.module}/lambda_function.zip"
  type        = "zip"
  depends_on = ["null_resource.lambda_buildstep"]
}

