# live-video DNS Delegation Management Terraform

This code manages the following domains delegations:

* `live-video.a2z.com`
* `live-video-ext.a2z.com`
* `live-video.net`
* `hls.live-video.net`
* `ttvnw.net`
* `hls.ttvnw.net`


This will setup the service subdomain required for delegations.

# Usage

<!-- MarkdownTOC autolink="true" -->

- [Requirements](#requirements)
- [Enrolling new services](#enrolling-new-services)
- [Deployment](#deployment)
  - [Example output](#example-output)
- [Cleanup](#cleanup)
- [Development](#development)

<!-- /MarkdownTOC -->

## Requirements

* [tfenv](https://github.com/tfutils/tfenv#automatic)
* AWS credentials to assume `lvs-dns-delegation` role in either
  * `twitch-bs-video-lvs-dns@amazon.com` account for `live-video.a2z.com` domain.

    ```bash
    # live-video.a2z.com
    isengardcli creds twitch-bs-video-lvs-dns --role lvs-dns-delegation
    ```
  * `twitch-bs-video-lvs-dns+external@amazon.com` account for `live-video-ext.a2z.com` domain.

    ```bash
    # live-video-ext.a2z.com
    isengardcli creds twitch-bs-video-lvs-dns+external --role lvs-dns-delegation
    ```

  * `twitch-live-video-net-dns@amazon.com` account for `live-video.net` domain.

    ```bash
    # live-video.net
    isengardcli creds twitch-live-video-net-dns --role lvs-dns-delegation
    ```

  * `twitch-vidcs+ttvnw-net-dns@amazon.com` account for `ttvnw.net` domain.
    ```bash
    # ttvnw.net
    isengardcli creds twitch-vidcs+ttvnw-net-dns --role lvs-dns-delegation
    ```

* AWS credentials to assume `tf-pop-dns-mgmt` role in

  * `twitch-hls-dns@amazon.com` account for `hls.live-video.net` domain.

    ```bash
    # hls.live-video.net
    isengardcli creds twitch-hls-dns --role tf-pop-dns-mgmt
    ```

  * `twitch-vidcs+hls-ttvnw-net-dns@amazon.com` account for `hls.ttvnw.net` domain.

    ```bash
    # hls.ttvnw.net
    isengardcli creds twitch-vidcs+hls-ttvnw-net-dns --role tf-pop-dns-mgmt
    ```

## Enrolling new services

1. Create a new `<service>.tfvars` under the respective [services/\<domain\>](./services) folder.
1. Populate the file with the following information. This information should be provided in the VidCS ticket as [instructed here](https://git.xarth.tv/video-coreservices/tf-mod-live-video-dns-delegation#request-a-service-subdomain).

    ```hcl
    # JIRA-XXX: <team_name>
    service = "<The name of the service>"

    subdomain_account_id   = "<The account_id where the Route53 subdomain lives>"
    subdomain_account_name = "<The name of the account that this subdoain will be delegated to>"
    subdomain_route53_id   = "<The Route53 zone id of the subdomain>"
    ```

    Refer [puppet](./services/live-video.a2z.com/puppet.tfvars) as an example.

## Deployment

To deploy a new service or modify an existing service:

1. `./deploy.sh -s <service> -d <domain> <plan|apply> ...`

   E.g.

   ```
   ./deploy.sh -s puppet -d live-video.a2z.com plan
   ./deploy.sh -s puppet -d live-video.a2z.com apply
   ```
1. As an additional validation, terraform `records` output and should match terraform `name_servers` output provided by the requestor.

### Example output

```bash
$ ./deploy.sh -s puppet -d live-video.a2z.com plan

Initializing the backend...

Successfully configured the backend "s3"! Terraform will automatically
use this backend unless the backend configuration changes.

Initializing provider plugins...

The following providers do not have any version constraints in configuration,
so the latest version was installed.

To prevent automatic upgrades to new major versions that may contain breaking
changes, it is recommended to add version = "..." constraints to the
corresponding provider blocks in configuration, with the constraint strings
suggested below.

* provider.aws: version = "~> 2.25"
* provider.null: version = "~> 2.1"

Terraform has been successfully initialized!

You may now begin working with Terraform. Try running "terraform plan" to see
any changes that are required for your infrastructure. All Terraform commands
should now work.

If you ever set or change modules or backend configuration for Terraform,
rerun this command to reinitialize your working directory. If you forget, other
commands will detect it and remind you to do so if necessary.
Refreshing Terraform state in-memory prior to plan...
The refreshed state will be used to calculate this plan, but will not be
persisted to local or remote state storage.

data.aws_route53_zone.subdomain: Refreshing state...

------------------------------------------------------------------------

An execution plan has been generated and is shown below.
Resource actions are indicated with the following symbols:
  + create

Terraform will perform the following actions:

  # aws_route53_record.comment will be created
  + resource "aws_route53_record" "comment" {
      + allow_overwrite = (known after apply)
      + fqdn            = (known after apply)
      + id              = (known after apply)
      + name            = "_comment.puppet.live-video.a2z.com"
      + records         = [
          + "Delegated to 678299527794 (twitch-video-puppet-dns)",
        ]
      + ttl             = 172800
      + type            = "TXT"
      + zone_id         = "Z3PBLIDNGDAXPF"
    }

  # aws_route53_record.subdomain will be created
  + resource "aws_route53_record" "subdomain" {
      + allow_overwrite = (known after apply)
      + fqdn            = (known after apply)
      + id              = (known after apply)
      + name            = "puppet.live-video.a2z.com"
      + records         = [
          + "ns-1100.awsdns-09.org",
          + "ns-2020.awsdns-60.co.uk",
          + "ns-411.awsdns-51.com",
          + "ns-554.awsdns-05.net",
        ]
      + ttl             = 172800
      + type            = "NS"
      + zone_id         = "Z3PBLIDNGDAXPF"
    }

Plan: 2 to add, 0 to change, 0 to destroy.

------------------------------------------------------------------------

Note: You didn't specify an "-out" parameter to save this plan, so Terraform
can't guarantee that exactly these actions will be performed if
"terraform apply" is subsequently run.
```

```bash
$ ./deploy.sh -s puppet output

comment = Delegated to 678299527794 (twitch-video-puppet-dns)
records = [
  "ns-1100.awsdns-09.org",
  "ns-2020.awsdns-60.co.uk",
  "ns-411.awsdns-51.com",
  "ns-554.awsdns-05.net",
]
subdomain = puppet.live-video.a2z.com
ttl = 172800
```

## Cleanup

Removing previous assigned delegations involves

1. Cleaning up previous DNS records.
1. Cleaning up terraform code and previous state file.

Luckily, this can all be done via the `cleanup` option, like so:

```
$ ./deploy.sh -s testservice -d testdomain cleanup
Initializing the backend...
Successfully configured the backend "s3"! Terraform will automatically use this backend unless the backend configuration changes.

Initializing provider plugins...

The following providers do not have any version constraints in configuration,
so the latest version was installed.

To prevent automatic upgrades to new major versions that may contain breaking
changes, it is recommended to add version = "..." constraints to the
corresponding provider blocks in configuration, with the constraint strings
suggested below.

* provider.aws: version = "~> 2.32"
* provider.null: version = "~> 2.1"

Terraform has been successfully initialized!

You may now begin working with Terraform. Try running "terraform plan" to see
any changes that are required for your infrastructure. All Terraform commands
should now work.

If you ever set or change modules or backend configuration for Terraform,
rerun this command to reinitialize your working directory. If you forget, other
commands will detect it and remind you to do so if necessary.

WARNING: This service's resources are still up and running - it may still be in use.
If you confirm you want to delete, the zone records will be destroyed.
Are you sure you want to delete zone testservice? [Yes|No]
yes
Starting record cleanup...
{
    "ChangeInfo": {
        "Id": "/change/C1MM4WYUV6DAJL",
        "Status": "PENDING",
        "SubmittedAt": "2020-01-27T22:32:17.686Z"
    }
}
{
    "ChangeInfo": {
        "Id": "/change/C2BUV90G4DZKZH",
        "Status": "PENDING",
        "SubmittedAt": "2020-01-27T22:32:18.460Z"
    }
}
Removed data.aws_route53_zone.subdomain
Removed aws_route53_record.comment
Removed aws_route53_record.subdomain
Successfully removed 3 resource instance(s).
Please open a pull request to have this change merged.
Done.
```
You can confirm that the records have been deleted by going to the [Route53 console](https://tiny.amazon.com/k2urt2ot/IsenLink) and searching the relevant record.

## Development

On OS X, the following requirements are available via [homebrew](https://brew.sh/).

* Setup [`pre-commit`](https://pre-commit.com/#install).
* Make sure the following dependencies are installed:
  * [`pre-commit terraform`](https://github.com/antonbabenko/pre-commit-terraform#step-1)

Run `pre-commit install` to install `pre-commit` hook.
